/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.sampled;

import java.util.ArrayList;
import java.util.Iterator;
import rasmus.interpreter.sampled.AudioVoice;

public class AudioVoiceManager {
    ArrayList voices;
    int maxpoly;
    long time = 0L;

    public long getTime() {
        return this.time++;
    }

    public int getMaxPolyphony() {
        return this.maxpoly;
    }

    public AudioVoiceManager(int maxpoly) {
        this.maxpoly = maxpoly;
        this.voices = new ArrayList(maxpoly + 10);
    }

    public void addVoice(AudioVoice voice) {
        if (this.voices.size() >= this.maxpoly) {
            Iterator itr = this.voices.iterator();
            AudioVoice found_voice = null;
            long found_offtime = -1L;
            while (itr.hasNext()) {
                AudioVoice element = (AudioVoice)itr.next();
                long a_offtime = element.getOffTime();
                if (a_offtime == -1L) continue;
                if (found_offtime == -1L) {
                    found_offtime = a_offtime;
                    found_voice = element;
                    continue;
                }
                if (a_offtime >= found_offtime) continue;
                found_offtime = a_offtime;
                found_voice = element;
            }
            if (found_voice != null) {
                found_voice.stopNow();
            } else {
                itr = this.voices.iterator();
                found_voice = null;
                long found_ontime = -1L;
                while (itr.hasNext()) {
                    AudioVoice element = (AudioVoice)itr.next();
                    long a_ontime = element.getOnTime();
                    if (a_ontime == -1L) continue;
                    if (found_ontime == -1L) {
                        found_ontime = a_ontime;
                        found_voice = element;
                        continue;
                    }
                    if (a_ontime >= found_ontime) continue;
                    found_ontime = a_ontime;
                    found_voice = element;
                }
                if (found_voice != null) {
                    found_voice.stopNow();
                }
            }
        }
        this.voices.add(voice);
    }

    public void removeVoice(AudioVoice voice) {
        this.voices.remove(voice);
    }
}

