/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.sampled;

import java.util.Arrays;
import java.util.concurrent.ArrayBlockingQueue;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.Receiver;
import javax.sound.midi.ShortMessage;
import rasmus.interpreter.Variable;
import rasmus.interpreter.math.DoublePart;
import rasmus.interpreter.midi.MidiSequence;
import rasmus.interpreter.sampled.AudioEvent;
import rasmus.interpreter.sampled.AudioEvents;
import rasmus.interpreter.sampled.AudioSession;
import rasmus.interpreter.sampled.AudioStream;
import rasmus.interpreter.sampled.AudioStreamable;
import rasmus.interpreter.unit.Parameters;
import rasmus.interpreter.unit.UnitInstancePart;

class AudioPlayerInstance
implements UnitInstancePart {
    static ShortMessage tickmessage = new ShortMessage();
    static ShortMessage stopmessage;
    static ShortMessage startmessage;
    Variable output;
    Variable input;
    Variable controlin;
    Variable controlout;
    Variable sync;
    Receiver syncout;
    Variable prebufferlen;
    Variable priority;
    Variable maxpolyphony;
    AudioPlayerInstance mpi = this;
    Receiver recv = new Receiver(){

        public void send(MidiMessage arg0, long arg1) {
            if (arg0 instanceof ShortMessage) {
                ShortMessage sms = (ShortMessage)arg0;
                if (sms.getStatus() == 250) {
                    AudioPlayerInstance.this.start();
                }
                if (sms.getStatus() == 252) {
                    AudioPlayerInstance.this.stop();
                }
                if (sms.getStatus() == 248) {
                    AudioPlayerInstance.this.clock();
                }
            }
        }

        public void close() {
        }
    };
    AudioStreamable streamable = new AudioStreamable(){

        public AudioStream openStream(AudioSession session) {
            return new MediaPlayerAudioStream(session);
        }
    };
    Variable audioevents = AudioEvents.asVariable(new AudioEvent(0.0, this.streamable));
    boolean playing = false;
    boolean syncstart = false;

    static {
        try {
            tickmessage.setMessage(249);
        }
        catch (InvalidMidiDataException e) {
            e.printStackTrace();
        }
        stopmessage = new ShortMessage();
        try {
            stopmessage.setMessage(252);
        }
        catch (InvalidMidiDataException e) {
            e.printStackTrace();
        }
        startmessage = new ShortMessage();
        try {
            startmessage.setMessage(250);
        }
        catch (InvalidMidiDataException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        this.stop();
        AudioPlayerInstance audioPlayerInstance = this;
        synchronized (audioPlayerInstance) {
            if (!this.playing) {
                this.syncstart = false;
                this.playing = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        AudioPlayerInstance audioPlayerInstance = this;
        synchronized (audioPlayerInstance) {
            if (this.playing) {
                this.syncstart = false;
                this.playing = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clock() {
        AudioPlayerInstance audioPlayerInstance = this;
        synchronized (audioPlayerInstance) {
            this.syncstart = true;
        }
    }

    public AudioPlayerInstance(Parameters parameters) {
        this.output = parameters.getParameterWithDefault("output");
        this.input = parameters.getParameterWithDefault("input");
        this.controlin = parameters.getParameterWithDefault(1, "controlin");
        this.controlout = parameters.getParameterWithDefault(2, "controlout");
        this.sync = parameters.getParameter(3, "sync");
        this.prebufferlen = parameters.getParameter(4, "prebuffer");
        this.priority = parameters.getParameter(5, "priority");
        this.maxpolyphony = parameters.getParameter(6, "maxpolyphony");
        Variable syncout = parameters.getParameter("syncout");
        if (syncout != null) {
            this.syncout = MidiSequence.getInstance(syncout);
        }
        MidiSequence.getInstance(this.controlin).addReceiver(this.recv);
        this.output.add(this.audioevents);
    }

    public void close() {
        this.stop();
        MidiSequence.getInstance(this.controlin).removeReceiver(this.recv);
        this.output.remove(this.audioevents);
    }

    class AudioFeeder
    implements Runnable {
        int bufferlen = 500;
        ArrayBlockingQueue<double[]> queue = null;
        double[][] buffers = null;
        double[] buffer;
        int curbuffindex = 0;
        AudioSession session;
        boolean buffering_active = true;
        boolean active = true;
        AudioStream stream = null;
        int totallen = 0;
        int buffer10mseclen = 0;
        boolean firstread = false;

        public boolean isBuffering() {
            return this.buffering_active;
        }

        public boolean isFull() {
            return this.queue.remainingCapacity() == 0;
        }

        public AudioFeeder(double rate, int channels) {
            if (AudioPlayerInstance.this.syncout != null) {
                AudioPlayerInstance.this.syncout.send(startmessage, -1L);
            }
            this.session = new AudioSession(rate, channels);
            this.session.setRealTime(false);
            this.totallen = this.buffer10mseclen = (int)(rate * 0.01) * channels;
            if (AudioPlayerInstance.this.maxpolyphony != null) {
                this.session.setMaxPolyphony((int)DoublePart.asDouble(AudioPlayerInstance.this.maxpolyphony));
            } else {
                this.session.setMaxPolyphony(40);
            }
            double d_prebufferlen = AudioPlayerInstance.this.prebufferlen != null ? DoublePart.asDouble(AudioPlayerInstance.this.prebufferlen) : 2.0;
            if (d_prebufferlen < 1.0E-4) {
                this.buffering_active = false;
            }
            this.bufferlen -= this.bufferlen % this.session.getChannels();
            if (!this.buffering_active) {
                this.buffer = new double[this.bufferlen];
                this.stream = this.session.openStream(AudioPlayerInstance.this.input);
                return;
            }
            int totalbufflen = (int)(this.session.getRate() * d_prebufferlen) * this.session.getChannels();
            int buffcount = totalbufflen / this.bufferlen + 1;
            this.queue = new ArrayBlockingQueue(buffcount);
            this.buffers = new double[buffcount + 10][this.bufferlen];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isActive() {
            AudioFeeder audioFeeder = this;
            synchronized (audioFeeder) {
                return this.active;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stopProcessing() {
            AudioFeeder audioFeeder = this;
            synchronized (audioFeeder) {
                this.active = false;
            }
            if (!this.buffering_active) {
                this.stream.close();
                this.session.close();
                this.stream = null;
                return;
            }
            this.queue.clear();
            if (AudioPlayerInstance.this.syncout != null) {
                AudioPlayerInstance.this.syncout.send(stopmessage, -1L);
            }
        }

        public double[] read() {
            if (AudioPlayerInstance.this.syncout != null) {
                if (this.totallen >= this.totallen) {
                    int c = this.totallen / this.buffer10mseclen;
                    this.totallen %= this.buffer10mseclen;
                    int i = 0;
                    while (i < c) {
                        AudioPlayerInstance.this.syncout.send(tickmessage, -1L);
                        ++i;
                    }
                }
                this.totallen += this.bufferlen;
            }
            if (!this.buffering_active) {
                if (this.stream == null) {
                    return null;
                }
                int ret = this.stream.replace(this.buffer, 0, this.buffer.length);
                if (ret == -1) {
                    return null;
                }
                if (ret != this.bufferlen) {
                    Arrays.fill(this.buffer, ret, this.bufferlen, 0.0);
                }
                return this.buffer;
            }
            return this.queue.poll();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            AudioFeeder audioFeeder;
            AudioStream stream = this.session.openStream(AudioPlayerInstance.this.input);
            while (true) {
                audioFeeder = this;
                synchronized (audioFeeder) {
                    if (!this.active) {
                        break;
                    }
                }
                ++this.curbuffindex;
                this.curbuffindex %= this.buffers.length;
                double[] buffer = this.buffers[this.curbuffindex];
                int ret = stream.replace(buffer, 0, this.bufferlen);
                if (ret == -1) break;
                if (ret != this.bufferlen) {
                    Arrays.fill(buffer, ret, this.bufferlen, 0.0);
                }
                try {
                    this.queue.put(buffer);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    break;
                }
            }
            stream.close();
            this.session.close();
            audioFeeder = this;
            synchronized (audioFeeder) {
                this.active = false;
            }
        }
    }

    private class MediaPlayerAudioStream
    implements AudioStream {
        AudioFeeder af;
        Thread thread;
        int syncmode;
        boolean af_active = false;
        boolean started = false;
        boolean active = false;
        AudioSession session;
        double[] readbuffer = null;
        int readpos = 0;

        public MediaPlayerAudioStream(AudioSession session) {
            this.session = session;
        }

        public void start() {
            if (this.af_active) {
                return;
            }
            this.af_active = true;
            this.syncmode = (int)DoublePart.asDouble(AudioPlayerInstance.this.sync);
            this.af = new AudioFeeder(this.session.getRate(), this.session.getChannels());
            if (!this.af.isBuffering()) {
                this.started = this.syncmode != 1;
                return;
            }
            this.thread = new Thread(this.af);
            if (AudioPlayerInstance.this.priority != null) {
                double pri = DoublePart.asDouble(AudioPlayerInstance.this.priority);
                if (pri > 0.5) {
                    this.thread.setPriority(10);
                } else if (pri < -0.5) {
                    this.thread.setPriority(1);
                }
            } else {
                this.thread.setPriority(5);
            }
            this.thread.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stop() {
            if (!this.af_active) {
                return;
            }
            this.af_active = false;
            this.started = false;
            this.af.stopProcessing();
            AudioPlayerInstance audioPlayerInstance = AudioPlayerInstance.this;
            synchronized (audioPlayerInstance) {
                AudioPlayerInstance.this.playing = false;
                AudioPlayerInstance.this.syncstart = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isStarted() {
            boolean syncstart;
            boolean playing;
            AudioPlayerInstance audioPlayerInstance = AudioPlayerInstance.this;
            synchronized (audioPlayerInstance) {
                playing = AudioPlayerInstance.this.playing;
                syncstart = AudioPlayerInstance.this.syncstart;
            }
            if (!this.started) {
                if (playing) {
                    if (!this.af_active) {
                        this.start();
                    }
                    if (this.syncmode == 1) {
                        this.started = syncstart;
                    } else if (this.af.isFull() || !this.af.isActive()) {
                        this.started = true;
                    }
                }
            } else if (!playing) {
                this.started = false;
                this.stop();
            }
            return this.started;
        }

        /*
         * Unable to fully structure code
         */
        public int mix(double[] buffer, int start, int end) {
            if (!this.isStarted()) {
                return end - start;
            }
            curpos = start;
            r = this.readpos;
            while (curpos != end) {
                if (this.readbuffer == null) {
                    this.readbuffer = this.af.read();
                    r = 0;
                    if (this.readbuffer == null) {
                        if (this.af.isActive()) {
                            this.syncmode = 0;
                            this.started = false;
                            break;
                        }
                        if (curpos != 0) break;
                        this.stop();
                        return end - start;
                    }
                }
                if ((remain = this.readbuffer.length - r) < (out_remain = end - curpos)) ** GOTO lbl28
                while (curpos < end) {
                    v0 = curpos++;
                    buffer[v0] = buffer[v0] + this.readbuffer[r];
                    ++r;
                }
                curpos = end;
                break;
lbl-1000:
                // 1 sources

                {
                    v1 = curpos++;
                    buffer[v1] = buffer[v1] + this.readbuffer[r];
                    ++r;
lbl28:
                    // 2 sources

                    ** while (r < this.readbuffer.length)
                }
lbl29:
                // 1 sources

                this.readbuffer = null;
            }
            this.readpos = r;
            return curpos - start;
        }

        /*
         * Unable to fully structure code
         */
        public int replace(double[] buffer, int start, int end) {
            if (!this.isStarted()) {
                Arrays.fill(buffer, start, end, 0.0);
                return end - start;
            }
            curpos = start;
            r = this.readpos;
            while (curpos != end) {
                if (this.readbuffer == null) {
                    this.readbuffer = this.af.read();
                    r = 0;
                    if (this.readbuffer == null) {
                        if (this.af.isActive()) {
                            this.syncmode = 0;
                            this.started = false;
                            break;
                        }
                        if (curpos != 0) break;
                        this.stop();
                        Arrays.fill(buffer, start, end, 0.0);
                        return end - start;
                    }
                }
                if ((remain = this.readbuffer.length - r) < (out_remain = end - curpos)) ** GOTO lbl30
                while (curpos < end) {
                    buffer[curpos] = this.readbuffer[r];
                    ++r;
                    ++curpos;
                }
                curpos = end;
                break;
lbl-1000:
                // 1 sources

                {
                    buffer[curpos] = this.readbuffer[r];
                    ++r;
                    ++curpos;
lbl30:
                    // 2 sources

                    ** while (r < this.readbuffer.length)
                }
lbl31:
                // 1 sources

                this.readbuffer = null;
            }
            this.readpos = r;
            return curpos - start;
        }

        public int isStatic(double[] buffer, int len) {
            if (!this.isStarted()) {
                return len;
            }
            return -1;
        }

        public int skip(int len) {
            if (!this.isStarted()) {
                return len;
            }
            int curpos = 0;
            int r = this.readpos;
            while (curpos != len) {
                int out_remain;
                int remain;
                if (this.readbuffer == null) {
                    this.readbuffer = this.af.read();
                    r = 0;
                    if (this.readbuffer == null) {
                        if (this.af.isActive()) {
                            this.syncmode = 0;
                            this.started = false;
                            break;
                        }
                        if (curpos != 0) break;
                        this.stop();
                        return len;
                    }
                }
                if ((remain = this.readbuffer.length - r) >= (out_remain = len - curpos)) {
                    curpos = len;
                    break;
                }
                this.readbuffer = null;
            }
            this.readpos = r;
            return curpos;
        }

        public void close() {
            this.stop();
        }
    }
}

