/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.sampled;

import java.util.Arrays;
import rasmus.interpreter.sampled.AudioStream;

public class AudioFallBackStream
implements AudioStream {
    public AudioStream audiostream;
    boolean fallbackable = false;
    boolean fallbackmode = false;
    double fallbackvalue = 0.0;
    int fallbackret = -1;

    public AudioFallBackStream(AudioStream audiostream) {
        if (audiostream == null) {
            System.out.println("null error");
        }
        this.audiostream = audiostream;
    }

    public AudioStream getAudioStream() {
        return this.audiostream;
    }

    public int skip(int len) {
        this.fallbackable = false;
        if (this.fallbackmode) {
            this.fallbackmode = false;
            return this.fallbackret;
        }
        return this.audiostream.skip(len);
    }

    public int mix(double[] buffer, int start, int end) {
        this.fallbackable = false;
        if (this.fallbackmode) {
            this.fallbackmode = false;
            if (end - start > this.fallbackret) {
                end = this.fallbackret + start;
            }
            double fv = this.fallbackvalue;
            int i = start;
            while (i < end) {
                int n = i++;
                buffer[n] = buffer[n] + fv;
            }
            return this.fallbackret;
        }
        return this.audiostream.mix(buffer, start, end);
    }

    public int replace(double[] buffer, int start, int end) {
        this.fallbackable = false;
        if (this.fallbackmode) {
            this.fallbackmode = false;
            if (end - start > this.fallbackret) {
                end = this.fallbackret + start;
            }
            Arrays.fill(buffer, start, end, this.fallbackvalue);
            return this.fallbackret;
        }
        return this.audiostream.replace(buffer, start, end);
    }

    public int isStatic(double[] buffer, int len) {
        if (this.fallbackmode) {
            return -1;
        }
        this.fallbackable = true;
        int ret = this.audiostream.isStatic(buffer, len);
        if (ret != -1) {
            this.fallbackret = ret;
            this.fallbackable = true;
            this.fallbackvalue = buffer[0];
        }
        return ret;
    }

    public int isSilent(int len) {
        double[] buffer = new double[1];
        int ret = this.isStatic(buffer, len);
        if (ret == -1) {
            return -1;
        }
        if (buffer[0] == 0.0) {
            return ret;
        }
        this.fallBack();
        return -1;
    }

    public boolean fallBack() {
        if (!this.fallbackable) {
            return false;
        }
        this.fallbackable = false;
        this.fallbackmode = true;
        return true;
    }

    public void close() {
        if (this.audiostream != null) {
            this.audiostream.close();
        }
    }
}

