/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.sampled;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.Sequence;
import javax.sound.midi.Track;
import rasmus.interpreter.Variable;
import rasmus.interpreter.list.ListPart;
import rasmus.interpreter.list.ListPartListener;
import rasmus.interpreter.math.DoublePart;
import rasmus.interpreter.midi.MidiSequence;
import rasmus.interpreter.sampled.AudioEvent;
import rasmus.interpreter.sampled.AudioFallBackStream;
import rasmus.interpreter.sampled.AudioSession;
import rasmus.interpreter.sampled.AudioStream;
import rasmus.interpreter.sampled.AudioStreamable;
import rasmus.interpreter.sampled.BeatToTimeMapper;

public class AudioEvents
extends ListPart
implements AudioStreamable {
    public List track = new LinkedList();
    private ListPartListener listlistener = new ListPartListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void objectAdded(ListPart source, Object object) {
            List list = AudioEvents.this.track;
            synchronized (list) {
                AudioEvents.this.addEvent(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void eventRemoved(AudioEvent aevent) {
            if (aevent.start == 0.0) {
                ArrayList arrayList = AudioEvents.this.realtimestreams;
                synchronized (arrayList) {
                    for (AudioEventsStream aes : AudioEvents.this.realtimestreams) {
                        RemoveEventRunnable rer = new RemoveEventRunnable();
                        rer.aes = aes;
                        rer.aevent = aevent;
                        aes.audiosession.addToBatch(rer);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void objectRemoved(ListPart source, Object object) {
            List list = AudioEvents.this.track;
            synchronized (list) {
                if (object instanceof AudioEvent) {
                    AudioEvents.this.track.remove((AudioEvent)object);
                    this.eventRemoved((AudioEvent)object);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void objectsAdded(ListPart source, List list) {
            List list2 = AudioEvents.this.track;
            synchronized (list2) {
                for (Object object : list) {
                    if (!(object instanceof AudioEvent)) continue;
                    AudioEvents.this.addEvent((AudioEvent)object);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void objectsRemoved(ListPart source, List list) {
            List list2 = AudioEvents.this.track;
            synchronized (list2) {
                if (AudioEvents.this.track != null) {
                    AudioEvents.this.track.removeAll(list);
                    for (Object object : list) {
                        if (!(object instanceof AudioEvent)) continue;
                        this.eventRemoved((AudioEvent)object);
                    }
                }
            }
        }
    };
    private ArrayList realtimestreams = new ArrayList();
    static /* synthetic */ Class class$0;

    public static long TimeToStreamTime(double time, double rate, int channels) {
        long tcalctime = (long)(time * rate * (double)channels);
        tcalctime -= tcalctime % (long)channels;
        return tcalctime;
    }

    public static double StreamTimeToTime(double time, double rate, int channels) {
        return time / (rate * (double)channels);
    }

    public static BeatToTimeMapper getBeatToTimeMap(Variable variable) {
        return new SequencerBeatMap(MidiSequence.asSequence(variable));
    }

    public static AudioStream openStream(Variable variable, AudioSession session) {
        if (session.getBeatToTimeMap() == null) {
            session.setBeatToTimeMap(new SequencerBeatMap(MidiSequence.asSequence(variable)));
        }
        return AudioEvents.getInstance(variable).openStream(session);
    }

    public static AudioEvents getInstance(Variable variable) {
        return (AudioEvents)variable.get(AudioEvents.class);
    }

    public static void addEvent(Variable variable, AudioEvent event) {
        ((AudioEvents)variable.get(AudioEvents.class)).addObject(event);
    }

    public static Variable asVariable(AudioEvent event) {
        Variable variable = new Variable();
        AudioEvents events = (AudioEvents)variable.get(AudioEvents.class);
        events.addObject(event);
        events.setImmutable(true);
        return variable;
    }

    public AudioEvents() {
        this.forceAddListener(this.listlistener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEvent(Object object) {
        if (object instanceof AudioEvent) {
            AudioEvent aevent = (AudioEvent)object;
            if (aevent.start == 0.0) {
                ArrayList arrayList = this.realtimestreams;
                synchronized (arrayList) {
                    for (AudioEventsStream aes : this.realtimestreams) {
                        AddEventRunnable aer = new AddEventRunnable();
                        aer.aes = aes;
                        aer.aevent = aevent;
                        aes.audiosession.addToBatch(aer);
                    }
                }
            }
            ListIterator<AudioEvent> iter = this.track.listIterator();
            while (iter.hasNext()) {
                AudioEvent event = (AudioEvent)iter.next();
                if (!(event.start >= aevent.start)) continue;
                iter.set(aevent);
                iter.add(event);
                return;
            }
            this.track.add(aevent);
        }
    }

    public AudioStream openStream(AudioSession session) {
        AudioStream stream = this.openStream2(session);
        double dval = DoublePart.asDouble(this.getVariable());
        if (Math.abs(dval) > 1.0E-21) {
            stream = new DoubleAddStream(stream, dval);
        }
        return stream;
    }

    private AudioStream openStream2(AudioSession session) {
        if (!session.isRealTime() && this.track.size() == 1) {
            AudioEvent aevent = (AudioEvent)this.track.get(0);
            if (aevent.start == 0.0) {
                AudioStream ret = session.openStream(aevent.streamable);
                if (ret == null) {
                    return new AudioStream(){

                        public int mix(double[] buffer, int start, int end) {
                            return -1;
                        }

                        public int replace(double[] buffer, int start, int end) {
                            return -1;
                        }

                        public int isStatic(double[] buffer, int len) {
                            return -1;
                        }

                        public int skip(int len) {
                            return -1;
                        }

                        public void close() {
                        }
                    };
                }
                return ret;
            }
        }
        return new AudioEventsStream(session);
    }

    static class SequencerBeatMap
    implements BeatToTimeMapper {
        Track track;
        int trackpos = 0;
        double trackbeatpos = 0.0;
        ArrayList trackpairs = new ArrayList();
        double tconstant = 1.0 / (double)MidiSequence.DEFAULT_RES;
        long lasttickpos = 0L;

        public SequencerBeatMap(Sequence seq) {
            this.track = seq.getTracks()[0];
        }

        public double getTime(double beat) {
            double calctime = 0.0;
            double beatleft = beat;
            double[] pair = new double[]{0.0, 0.5};
            double lastfactor = pair[1];
            int i = 0;
            while (i < this.trackpairs.size()) {
                pair = (double[])this.trackpairs.get(i);
                if (pair[0] > beatleft) {
                    return calctime += beatleft * lastfactor;
                }
                calctime += pair[0] * lastfactor;
                lastfactor = pair[1];
                beatleft -= pair[0];
                ++i;
            }
            int tracklen = this.track.size();
            while (this.trackpos < tracklen) {
                MetaMessage mmsg;
                MidiEvent midievent = this.track.get(this.trackpos);
                if (midievent.getMessage() instanceof MetaMessage && (mmsg = (MetaMessage)midievent.getMessage()).getType() == 81) {
                    byte[] msg = mmsg.getData();
                    int tempoInMPQ = ((msg[0] & 0xFF) << 16) + ((msg[1] & 0xFF) << 8) + (msg[2] & 0xFF);
                    double tempo = 6.0E7 / (double)tempoInMPQ;
                    pair = new double[]{(double)(midievent.getTick() - this.lasttickpos) * this.tconstant, 1.0 / (tempo / 60.0)};
                    this.lasttickpos = midievent.getTick();
                    this.trackpairs.add(pair);
                    if (pair[0] > beatleft) {
                        return calctime += beatleft * lastfactor;
                    }
                    calctime += pair[0] * lastfactor;
                    lastfactor = pair[1];
                    beatleft -= pair[0];
                }
                ++this.trackpos;
            }
            return calctime += beatleft * lastfactor;
        }

        public double getBeat(double time) {
            double calcbeat = 0.0;
            double timeleft = time;
            double[] pair = new double[]{0.0, 0.5};
            double lastfactor = pair[1];
            int i = 0;
            while (i < this.trackpairs.size()) {
                pair = (double[])this.trackpairs.get(i);
                double beattime = pair[0] * lastfactor;
                if (pair[0] > timeleft) {
                    return calcbeat += timeleft / lastfactor;
                }
                calcbeat += pair[0];
                lastfactor = pair[1];
                timeleft -= beattime;
                ++i;
            }
            int tracklen = this.track.size();
            while (this.trackpos < tracklen) {
                MetaMessage mmsg;
                MidiEvent midievent = this.track.get(this.trackpos);
                if (midievent.getMessage() instanceof MetaMessage && (mmsg = (MetaMessage)midievent.getMessage()).getType() == 81) {
                    byte[] msg = mmsg.getData();
                    int tempoInMPQ = ((msg[0] & 0xFF) << 16) + ((msg[1] & 0xFF) << 8) + (msg[2] & 0xFF);
                    double tempo = 6.0E7 / (double)tempoInMPQ;
                    pair = new double[]{(double)(midievent.getTick() - this.lasttickpos) * this.tconstant, 1.0 / (tempo / 60.0)};
                    this.lasttickpos = midievent.getTick();
                    this.trackpairs.add(pair);
                    double beattime = pair[0] * lastfactor;
                    if (pair[0] > timeleft) {
                        return calcbeat += timeleft / lastfactor;
                    }
                    calcbeat += pair[0];
                    lastfactor = pair[1];
                    timeleft -= beattime;
                }
                ++this.trackpos;
            }
            return calcbeat += timeleft / lastfactor;
        }
    }

    private class AddEventRunnable
    implements Runnable {
        AudioEventsStream aes;
        AudioEvent aevent;

        AddEventRunnable() {
        }

        public void run() {
            if (this.aes.audiosession == null) {
                return;
            }
            AudioStream astream = this.aes.audiosession.openStream(this.aevent.getStreamable());
            if (astream != null) {
                astream = new AudioFallBackStream(astream);
                this.aes.currentevents.add(astream);
                this.aes.streamsowner.put(astream, this.aevent.getStreamable());
            }
        }
    }

    private class RemoveEventRunnable
    implements Runnable {
        AudioEventsStream aes;
        AudioEvent aevent;

        RemoveEventRunnable() {
        }

        public void run() {
            Iterator citerator = this.aes.currentevents.iterator();
            while (citerator.hasNext()) {
                AudioStream element = (AudioStream)citerator.next();
                if (this.aevent.streamable != this.aes.streamsowner.get(element)) continue;
                this.aes.streamsowner.remove(element);
                citerator.remove();
                element.close();
            }
        }
    }

    class BeatMapDelay
    implements BeatToTimeMapper {
        BeatToTimeMapper bmap;
        double delta;
        double starttime;

        public BeatMapDelay(BeatToTimeMapper bmap, double deltatime, double delta) {
            this.bmap = bmap;
            this.delta = delta;
            this.starttime = deltatime;
        }

        public double getTime(double beat) {
            return this.bmap.getTime(beat + this.delta) - this.starttime;
        }

        public double getBeat(double time) {
            return this.bmap.getBeat(time + this.starttime) - this.delta;
        }
    }

    class AudioEventsStream
    implements AudioStream {
        double rate;
        int channels;
        boolean realtime;
        long position;
        AudioEvent nextevent = null;
        long iposition = 0L;
        long nextpos = 0L;
        double nextbeat = 0.0;
        int trackpos = 0;
        BeatToTimeMapper bmap;
        LinkedList currentevents = new LinkedList();
        AudioSession audiosession;
        Hashtable streamsowner = new Hashtable();
        double[] sbuffer = new double[1];

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public AudioEventsStream(AudioSession session) {
            List list;
            this.audiosession = session;
            this.bmap = session.getBeatToTimeMap();
            this.rate = session.getRate();
            this.channels = session.getChannels();
            this.realtime = session.isRealTime();
            if (this.realtime) {
                list = AudioEvents.this.realtimestreams;
                synchronized (list) {
                    AudioEvents.this.realtimestreams.add(this);
                }
            }
            list = AudioEvents.this.track;
            synchronized (list) {
                if (this.trackpos < AudioEvents.this.track.size()) {
                    this.nextevent = (AudioEvent)AudioEvents.this.track.get(this.trackpos);
                    this.nextpos = AudioEvents.TimeToStreamTime(this.bmap.getTime(this.nextevent.start), this.rate, this.channels);
                    ++this.trackpos;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int skip(int len) {
            int readed = -1;
            Iterator citerator = this.currentevents.iterator();
            while (citerator.hasNext()) {
                AudioStream astream = (AudioStream)citerator.next();
                int aread = astream.skip(len);
                if (aread > readed) {
                    readed = aread;
                }
                if (aread != -1) continue;
                citerator.remove();
                astream.close();
                this.streamsowner.remove(astream);
            }
            while (this.nextevent != null) {
                long estart = this.nextpos - this.position;
                if (estart > (long)len) {
                    readed = len;
                    break;
                }
                if (estart < 0L) break;
                AudioStream astream = null;
                if (this.position + this.nextpos == 0L) {
                    astream = this.audiosession.openStream(this.nextevent.getStreamable());
                } else if ((double)((long)len - estart) < this.audiosession.getRate() * (double)this.audiosession.getChannels()) {
                    AudioSession newsession = this.audiosession.newSession();
                    newsession.setBeatToTimeMap(new BeatMapDelay(this.bmap, AudioEvents.StreamTimeToTime(this.nextpos, this.rate, this.channels), this.nextbeat));
                    astream = newsession.openStream(this.nextevent.getStreamable());
                }
                if (astream != null) {
                    int aread = astream.skip(len - (int)estart);
                    int bread = (int)(estart + (long)aread);
                    if (bread > readed) {
                        readed = bread;
                    }
                    if (aread != -1) {
                        astream = new AudioFallBackStream(astream);
                        this.currentevents.add(astream);
                        this.streamsowner.put(astream, this.nextevent.getStreamable());
                    } else {
                        astream.close();
                    }
                }
                List list = AudioEvents.this.track;
                synchronized (list) {
                    if (this.trackpos < AudioEvents.this.track.size()) {
                        this.nextevent = (AudioEvent)AudioEvents.this.track.get(this.trackpos);
                        this.nextbeat = this.nextevent.start;
                        this.nextpos = AudioEvents.TimeToStreamTime(this.bmap.getTime(this.nextevent.start), this.rate, this.channels);
                        ++this.trackpos;
                    } else {
                        this.nextevent = null;
                        this.nextbeat = 0.0;
                        this.nextpos = 0L;
                    }
                }
            }
            this.position += (long)len;
            return readed;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int mix(double[] buffer, int start, int end) {
            if (this.realtime && this.currentevents.size() == 1 && this.nextevent == null) {
                AudioFallBackStream astream = (AudioFallBackStream)this.currentevents.get(0);
                return astream.audiostream.mix(buffer, start, end);
            }
            int len = end - start;
            int readed = -1;
            Iterator citerator = this.currentevents.iterator();
            while (citerator.hasNext()) {
                AudioStream astream = (AudioStream)citerator.next();
                int aread = astream.isStatic(this.sbuffer, end - start);
                if (aread != -1) {
                    if (this.sbuffer[0] != 0.0) {
                        int i = start;
                        while (i < start + aread) {
                            int n = i++;
                            buffer[n] = buffer[n] + this.sbuffer[0];
                        }
                    }
                } else {
                    aread = astream.mix(buffer, start, end);
                }
                if (aread > readed) {
                    readed = aread;
                }
                if (aread != -1) continue;
                this.streamsowner.remove(astream);
                citerator.remove();
                astream.close();
            }
            AudioSession audiosession = this.audiosession;
            long cursespos = 0L;
            while (this.nextevent != null) {
                AudioStream astream;
                long estart = this.nextpos - this.position;
                if (estart > (long)len) {
                    readed = len;
                    break;
                }
                if (estart < 0L) break;
                if (this.nextpos != cursespos) {
                    audiosession = this.audiosession.newSession();
                    audiosession.setBeatToTimeMap(new BeatMapDelay(this.bmap, AudioEvents.StreamTimeToTime(this.nextpos, this.rate, this.channels), this.nextbeat));
                    cursespos = this.nextpos;
                }
                if ((astream = audiosession.openStream(this.nextevent.getStreamable())) != null) {
                    int aread = astream.mix(buffer, (int)estart + start, end);
                    int bread = (int)(estart + (long)aread);
                    if (bread > readed) {
                        readed = bread;
                    }
                    if (aread != -1) {
                        astream = new AudioFallBackStream(astream);
                        this.streamsowner.put(astream, this.nextevent.getStreamable());
                        this.currentevents.add(astream);
                    } else {
                        astream.close();
                    }
                }
                List list = AudioEvents.this.track;
                synchronized (list) {
                    if (this.trackpos < AudioEvents.this.track.size()) {
                        this.nextevent = (AudioEvent)AudioEvents.this.track.get(this.trackpos);
                        this.nextbeat = this.nextevent.start;
                        this.nextpos = AudioEvents.TimeToStreamTime(this.bmap.getTime(this.nextbeat), this.rate, this.channels);
                        ++this.trackpos;
                    } else {
                        this.nextevent = null;
                        this.nextpos = 0L;
                        this.nextbeat = 0.0;
                    }
                }
            }
            this.position += (long)len;
            if (this.realtime) {
                readed = end - start;
            }
            return readed;
        }

        public int replace(double[] buffer, int start, int end) {
            if (this.realtime && this.currentevents.size() == 1 && this.nextevent == null) {
                AudioFallBackStream astream = (AudioFallBackStream)this.currentevents.get(0);
                return astream.audiostream.replace(buffer, start, end);
            }
            Arrays.fill(buffer, start, end, 0.0);
            return this.mix(buffer, start, end);
        }

        public int isStatic(double[] buffer, int len) {
            long estart;
            if (this.realtime && this.currentevents.size() == 1 && this.nextevent == null) {
                AudioFallBackStream astream = (AudioFallBackStream)this.currentevents.get(0);
                return astream.audiostream.isStatic(buffer, len);
            }
            if (this.nextevent != null && (estart = this.nextpos - this.position) >= 0L && estart < (long)len) {
                return -1;
            }
            this.position += (long)len;
            if (this.currentevents.size() == 0 && this.nextevent == null) {
                if (this.realtime) {
                    return len;
                }
                return -1;
            }
            double[] abuffer = new double[1];
            ArrayList<AudioFallBackStream> fallbacklist = new ArrayList<AudioFallBackStream>();
            for (AudioFallBackStream audiostream : this.currentevents) {
                int ret = audiostream.isStatic(abuffer, len);
                if (ret != -1) {
                    fallbacklist.add(audiostream);
                }
                if (ret != len) {
                    this.position -= (long)len;
                    Iterator fiter = fallbacklist.iterator();
                    while (fiter.hasNext()) {
                        ((AudioFallBackStream)fiter.next()).fallBack();
                    }
                    return -1;
                }
                if (ret != -1) continue;
                this.position -= (long)len;
                Iterator fiter = fallbacklist.iterator();
                while (fiter.hasNext()) {
                    ((AudioFallBackStream)fiter.next()).fallBack();
                }
                return -1;
            }
            return len;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            if (this.realtime) {
                ArrayList arrayList = AudioEvents.this.realtimestreams;
                synchronized (arrayList) {
                    AudioEvents.this.realtimestreams.remove(this);
                }
            }
            for (AudioStream astream : this.currentevents) {
                astream.close();
            }
            this.streamsowner.clear();
            this.currentevents.clear();
            this.nextevent = null;
            this.audiosession = null;
        }
    }

    class DoubleAddStream
    implements AudioStream {
        AudioStream stream;
        double val;

        public DoubleAddStream(AudioStream stream, double val) {
            this.stream = stream;
            this.val = val;
        }

        public int mix(double[] buffer, int start, int end) {
            int ret = this.stream.mix(buffer, start, end);
            if (ret != -1) {
                end = start + ret;
                double fval = this.val;
                int i = start;
                while (i < end) {
                    int n = i++;
                    buffer[n] = buffer[n] + fval;
                }
            }
            return ret;
        }

        public int replace(double[] buffer, int start, int end) {
            int ret = this.stream.replace(buffer, start, end);
            if (ret != -1) {
                end = start + ret;
                double fval = this.val;
                int i = start;
                while (i < end) {
                    int n = i++;
                    buffer[n] = buffer[n] + fval;
                }
            }
            return ret;
        }

        public int isStatic(double[] buffer, int len) {
            int ret = this.stream.isStatic(buffer, len);
            if (ret != -1) {
                buffer[0] = buffer[0] + this.val;
            }
            return ret;
        }

        public int skip(int len) {
            return -1;
        }

        public void close() {
            this.stream.close();
        }
    }
}

