/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.parser;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import rasmus.interpreter.NameSpace;
import rasmus.interpreter.unit.Unit;

public class ScriptTokenParser {
    public static final String hexDigits = "0123456789ABCDEFabcdef";
    public static final int STATUS_NORMAL = 0;
    public static final int STATUS_SINGLE_QUOTE_STRING = 1;
    public static final int STATUS_DOUBLE_QUOTE_STRING = 2;
    public static final int STATUS_PRE_COMMENTS = 3;
    public static final int STATUS_SINGLE_LINE_COMMENTS = 4;
    public static final int STATUS_MULTI_LINE_COMMENTS = 5;
    public static final int STATUS_MULTI_LINE_COMMENTS_PRE_END = 6;
    public static final int STATUS_MULTI_LINE_SINGLE_QUOTE_STRING = 7;
    public static final int STATUS_MULTI_LINE_DOUBLE_QUOTE_STRING = 8;
    public static final int STATUS_MULTI_LINE_SINGLE_QUOTE_STRING_PRE_END = 9;
    public static final int STATUS_MULTI_LINE_DOUBLE_QUOTE_STRING_PRE_END = 10;
    public static final String symbols = "=+-<>/!*^&(),{};";
    Set registered_variables = new HashSet();
    Set possible_functions = new HashSet();
    Set functions = new HashSet();
    NameSpace namespace;

    public static String[] extractStatemensResultGenerators(String statement) {
        boolean isstring;
        char c;
        statement = ScriptTokenParser.removeComments(statement);
        char[] codec = statement.toCharArray();
        int status = 0;
        char lastc = ' ';
        int li = -1;
        int i = 0;
        while (i < codec.length) {
            c = codec[i];
            isstring = ScriptTokenParser.isStringStatus(status = ScriptTokenParser.parseStatus(c, status));
            if (!isstring) {
                if (lastc == '<' && c == '-') {
                    li = i - 1;
                    break;
                }
                lastc = c;
            }
            ++i;
        }
        if (li == -1) {
            return null;
        }
        statement = statement.substring(li + 2).trim();
        codec = statement.toCharArray();
        li = -1;
        i = 0;
        while (i < codec.length) {
            c = codec[i];
            isstring = ScriptTokenParser.isStringStatus(status = ScriptTokenParser.parseStatus(c, status));
            if (!isstring) {
                if (c == '+') {
                    return null;
                }
                if (c == '-') {
                    return null;
                }
                if (c == '*') {
                    return null;
                }
                if (c == '/') {
                    return null;
                }
                if (c == '^') {
                    return null;
                }
                if (c == '{') {
                    return null;
                }
                if (c == '(') {
                    String[] strs = new String[]{statement.substring(0, i).trim()};
                    return strs;
                }
                if (lastc == '<' && c == '-') {
                    li = i - 1;
                    break;
                }
                lastc = c;
            }
            ++i;
        }
        return null;
    }

    public static String extractStatementResultVariable(String statement) {
        char[] codec = statement.toCharArray();
        int status = 0;
        int lastc = 32;
        int li = -1;
        int i = 0;
        while (i < codec.length) {
            int c = codec[i];
            status = ScriptTokenParser.parseStatus((char)c, status);
            boolean iscomment = ScriptTokenParser.isCommentStatus(status);
            boolean isstring = ScriptTokenParser.isStringStatus(status);
            if (!iscomment && !isstring) {
                if (lastc == 60 && c == 45) {
                    li = i - 1;
                    break;
                }
                lastc = c;
            }
            ++i;
        }
        if (li == -1) {
            return null;
        }
        String st = ScriptTokenParser.removeComments(statement.substring(0, li)).trim();
        if (st.length() == 0) {
            return "output";
        }
        if (st.contains("(")) {
            return null;
        }
        return st;
    }

    public static String removeComments(String statement) {
        StringBuffer buffer = new StringBuffer();
        char[] codec = statement.toCharArray();
        int status = 0;
        int i = 0;
        while (i < codec.length) {
            boolean iscomment;
            int nextstatus;
            char c = codec[i];
            int laststatus = status;
            if ((status = ScriptTokenParser.parseStatus(c, status)) == 3 && i + 1 < codec.length && ScriptTokenParser.isCommentStatus(nextstatus = ScriptTokenParser.parseStatus(codec[i + 1], status))) {
                status = nextstatus;
            }
            if (!(iscomment = ScriptTokenParser.isCommentStatus(status)) && !ScriptTokenParser.isCommentStatus(laststatus)) {
                buffer.append(c);
            }
            ++i;
        }
        return buffer.toString();
    }

    public static String removeCommentsAndWhiteSpace(String statement) {
        StringBuffer buffer = new StringBuffer();
        char[] codec = statement.toCharArray();
        int status = 0;
        int i = 0;
        while (i < codec.length) {
            int nextstatus;
            char c = codec[i];
            int laststatus = status;
            if ((status = ScriptTokenParser.parseStatus(c, status)) == 3 && i + 1 < codec.length && ScriptTokenParser.isCommentStatus(nextstatus = ScriptTokenParser.parseStatus(codec[i + 1], status))) {
                status = nextstatus;
            }
            boolean iscomment = ScriptTokenParser.isCommentStatus(status);
            boolean isstring = ScriptTokenParser.isStringStatus(status);
            if (!(iscomment || ScriptTokenParser.isCommentStatus(laststatus) || !isstring && Character.isWhitespace(c))) {
                buffer.append(c);
            }
            ++i;
        }
        return buffer.toString();
    }

    public static String[] seperateStatements(String code) {
        ArrayList<String> strings = new ArrayList<String>();
        char[] codec = code.toCharArray();
        int status = 0;
        int nestlevel = 0;
        int lasti = 0;
        int i = 0;
        while (i < codec.length) {
            char c = codec[i];
            status = ScriptTokenParser.parseStatus(c, status);
            if (c == '{') {
                ++nestlevel;
            } else if (c == '}' && nestlevel > 1) {
                --nestlevel;
            } else if (c == ';' && nestlevel == 0 || c == '}' && nestlevel == 1) {
                nestlevel = 0;
                boolean iscomment = ScriptTokenParser.isCommentStatus(status);
                boolean isstring = ScriptTokenParser.isStringStatus(status);
                if (!iscomment && !isstring) {
                    strings.add(code.substring(lasti, i + 1));
                    lasti = i + 1;
                }
            }
            ++i;
        }
        strings.add(code.substring(lasti, code.length()));
        return strings.toArray(new String[strings.size()]);
    }

    public static boolean isCommentStatus(int status) {
        if (status == 4) {
            return true;
        }
        if (status == 5) {
            return true;
        }
        return status == 6;
    }

    public static boolean isNumber(String value) {
        if (value.startsWith("0x")) {
            int i = 2;
            while (i < value.length()) {
                char c = value.charAt(i);
                if (hexDigits.indexOf(c) == -1) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        boolean float_symbol = false;
        int i = 0;
        while (i < value.length()) {
            char c = value.charAt(i);
            if (c == '.') {
                if (float_symbol) {
                    return false;
                }
                float_symbol = true;
            } else {
                if (c == '%') {
                    int j = i + 1;
                    while (j < value.length()) {
                        c = value.charAt(j);
                        if (c != '%') {
                            return false;
                        }
                        ++j;
                    }
                    return true;
                }
                if (!Character.isDigit(c)) {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    public static boolean isStringStatus(int status) {
        if (status == 1) {
            return true;
        }
        if (status == 2) {
            return true;
        }
        if (status == 7) {
            return true;
        }
        if (status == 8) {
            return true;
        }
        if (status == 9) {
            return true;
        }
        return status == 10;
    }

    public static String makeFunctionCall(String[] values) {
        StringBuffer sb = new StringBuffer();
        sb.append(String.valueOf(values[0]) + "(");
        int i = 1;
        while (i < values.length) {
            if (i != 1) {
                sb.append(",");
            }
            sb.append(values[i]);
            ++i;
        }
        sb.append(")");
        return sb.toString();
    }

    public static String[] parseFunctionCall(String value) {
        int li = value.indexOf("(");
        if (li == -1) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        String funcName = value.substring(0, li);
        list.add(funcName);
        value = value.substring(li);
        if (value.startsWith("(")) {
            value = value.substring(1);
        }
        if (value.endsWith(")")) {
            value = value.substring(0, value.length() - 1);
        }
        StringBuffer paramvalue = new StringBuffer();
        int status = 0;
        int clevel = 0;
        int i = 0;
        while (i < value.length()) {
            char cc = value.charAt(i);
            status = ScriptTokenParser.parseStatus(cc, status);
            paramvalue.append(cc);
            if (status == 0) {
                if (cc == '(') {
                    ++clevel;
                } else if (cc == ')') {
                    --clevel;
                }
                if (clevel == 0 && cc == ',') {
                    list.add(paramvalue.substring(0, paramvalue.length() - 1));
                    paramvalue.setLength(0);
                }
            }
            ++i;
        }
        list.add(paramvalue.toString());
        return list.toArray(new String[list.size()]);
    }

    public static int parseStatus(char c, int status) {
        switch (status) {
            case 0: {
                if (c == '\'') {
                    return 1;
                }
                if (c == '\"') {
                    return 2;
                }
                if (c != '/') break;
                return 3;
            }
            case 1: {
                if (c == '\'') {
                    return 0;
                }
                if (c == '\n') {
                    return 0;
                }
                if (c != '\r') break;
                return 0;
            }
            case 2: {
                if (c == '\"') {
                    return 0;
                }
                if (c == '\n') {
                    return 0;
                }
                if (c != '\r') break;
                return 0;
            }
            case 3: {
                if (c == '/') {
                    return 4;
                }
                if (c == '*') {
                    return 5;
                }
                if (c == '\'') {
                    return 7;
                }
                if (c == '\"') {
                    return 8;
                }
                return 0;
            }
            case 4: {
                if (c != '\n' && c != '\r') break;
                return 0;
            }
            case 5: {
                if (c != '*') break;
                return 6;
            }
            case 6: {
                if (c == '/') {
                    return 0;
                }
                if (c == '*') {
                    return 6;
                }
                return 5;
            }
            case 7: {
                if (c != '\'') break;
                return 9;
            }
            case 8: {
                if (c != '\"') break;
                return 10;
            }
            case 9: {
                if (c == '/') {
                    return 0;
                }
                if (c == '\'') {
                    return 9;
                }
                return 7;
            }
            case 10: {
                if (c == '/') {
                    return 0;
                }
                if (c == '\"') {
                    return 10;
                }
                return 8;
            }
        }
        return status;
    }

    public static int parseStatus(String string, int status) {
        int i = 0;
        while (i < string.length()) {
            char c = string.charAt(i);
            status = ScriptTokenParser.parseStatus(c, status);
            ++i;
        }
        return status;
    }

    public static String[] seperateParamNameAndValue(String value) {
        String[] pair = new String[]{null, value};
        int status = 0;
        int i = 0;
        while (i < value.length()) {
            char cc = value.charAt(i);
            status = ScriptTokenParser.parseStatus(cc, status);
            if (status == 0 && cc == '=') {
                pair[0] = value.substring(0, i);
                pair[1] = value.substring(i + 1);
                return pair;
            }
            ++i;
        }
        return pair;
    }

    public static boolean isVariableOrNumberLetter(char c) {
        return Character.isLetter(c) || Character.isDigit(c) || c == '%' || c == '.' || c == '_' || c == '#';
    }

    public ScriptTokenParser(NameSpace namespace) {
        this.namespace = namespace;
        if (namespace != null) {
            namespace.getAllNames(this.registered_variables);
            this.possible_functions.addAll(this.registered_variables);
            this.functions.add("function");
            this.functions.add("use");
            this.functions.add("module");
            this.functions.add("namespace");
        }
    }

    public boolean isRegisteredVariable(String value) {
        if (value.startsWith("global.")) {
            value = value.substring(7);
        }
        return this.registered_variables.contains(value.toLowerCase());
    }

    public boolean isFunction(String value) {
        boolean isfunc;
        String lvalue;
        if (value.startsWith("global.")) {
            value = value.substring(7);
        }
        if (this.functions.contains(lvalue = value.toLowerCase())) {
            return true;
        }
        if (!this.possible_functions.contains(lvalue)) {
            return false;
        }
        this.possible_functions.remove(lvalue);
        boolean bl = isfunc = !Unit.getInstance(this.namespace.get(value)).getObjects().isEmpty();
        if (isfunc) {
            this.functions.add(lvalue);
        }
        return isfunc;
    }
}

