/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.parser;

import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import rasmus.interpreter.parser.ScriptElement;
import rasmus.interpreter.parser.ScriptParserException;
import rasmus.interpreter.parser.ScriptTokenParser;
import rasmus.interpreter.parser.ScriptTokenizer;

public class ScriptParser {
    private ScriptTokenizer tokenzier;
    private ScriptElement root = new ScriptElement(0);
    private int index = 0;
    private String script;
    private ArrayList infixOperators = new ArrayList();
    private String lastendtoken;

    public static ScriptElement parse(String script) throws ScriptParserException {
        ScriptParser parser = new ScriptParser(script);
        return parser.root;
    }

    private int[] extractLineCol(int index) {
        int line = 1;
        int col = 1;
        int lastc = 32;
        int i = 0;
        while (i < index) {
            int c = this.script.charAt(i);
            if (c == 10 || c == 13) {
                if (lastc != 10 && lastc != 13 || lastc == c) {
                    ++line;
                    col = 1;
                } else {
                    c = 32;
                }
            } else {
                ++col;
            }
            lastc = c;
            ++i;
        }
        int[] linecol = new int[]{line, col};
        return linecol;
    }

    private ScriptParserException makeException(int offset, String message) {
        int[] linecol = this.extractLineCol(offset);
        int line = linecol[0];
        int col = linecol[1];
        int firstindex = this.index - 20;
        if (firstindex < 0) {
            firstindex = 0;
        }
        String detail = this.script.substring(firstindex, this.index);
        detail = String.valueOf(detail) + " <-- !!! \n";
        detail = String.valueOf(detail) + "line " + line + ", col = " + col + ", offset = " + offset + " : ";
        return new ScriptParserException(offset, line, col, message, detail);
    }

    private ScriptParser(String script) throws ScriptParserException {
        this.infixOperators.add("^");
        this.infixOperators.add("/");
        this.infixOperators.add("*");
        this.infixOperators.add("-");
        this.infixOperators.add("+");
        this.infixOperators.add("&");
        this.infixOperators.add("<");
        this.infixOperators.add(">");
        this.infixOperators.add("<=");
        this.infixOperators.add(">=");
        this.infixOperators.add("!=");
        this.infixOperators.add("=");
        this.lastendtoken = null;
        this.tokenzier = new ScriptTokenizer(script);
        this.script = script;
        this.parseScript(this.root);
    }

    private Double parseNumber(String token) throws ScriptParserException {
        try {
            if (token.startsWith("0x")) {
                return Long.parseLong(token.substring(2), 16);
            }
            double identity = 1.0;
            while (token.endsWith("%")) {
                identity *= 0.01;
                token = token.substring(0, token.length() - 1);
            }
            return identity * Double.parseDouble(token);
        }
        catch (Throwable t) {
            throw this.makeException(this.index, t.getMessage());
        }
    }

    private ScriptElement parseValueToken(String token) throws ScriptParserException {
        if (token == null) {
            return null;
        }
        if (token.startsWith("/\"")) {
            if (!token.endsWith("\"/")) {
                throw this.makeException(this.index, "String ending is missing.");
            }
            return new ScriptElement(4, token.substring(2, token.length() - 2));
        }
        if (token.startsWith("/'")) {
            if (!token.endsWith("'/")) {
                throw this.makeException(this.index, "String ending is missing.");
            }
            return new ScriptElement(4, token.substring(2, token.length() - 2));
        }
        if (token.startsWith("\"") || token.startsWith("'")) {
            if (!token.endsWith(token.substring(0, 1))) {
                throw this.makeException(this.index, "String ending is missing.");
            }
            return new ScriptElement(4, token.substring(1, token.length() - 1));
        }
        if (ScriptTokenParser.isNumber(token)) {
            return new ScriptElement(5, this.parseNumber(token));
        }
        if (token.length() == 1) {
            char c = token.charAt(0);
            if (c == '(') {
                return this.parseExpression(")", false);
            }
            if (c == '!' || c == '-') {
                ScriptElement callelement = new ScriptElement(2, token);
                ScriptElement param = new ScriptElement(3, "1");
                callelement.add(param);
                if (!this.tokenzier.hasMoreTokens()) {
                    throw this.makeException(this.index, "Was expecting value token.");
                }
                token = this.tokenzier.nextToken();
                this.index = this.tokenzier.lastIndex();
                ScriptElement valueelement = this.parseValueToken(token);
                if (valueelement == null) {
                    throw this.makeException(this.index, "Was expecting value token.");
                }
                param.add(valueelement);
                return callelement;
            }
            if ("=+-<>/!*^&(),{};".indexOf(token.charAt(0)) != -1) {
                return null;
            }
        } else if (token.length() == 2) {
            if (token.equals("<-")) {
                return null;
            }
            if (token.equals(">=")) {
                return null;
            }
            if (token.equals("<=")) {
                return null;
            }
            if (token.equals("!=")) {
                return null;
            }
        }
        try {
            String value;
            if (!(!this.tokenzier.peekNextToken().equals("(") || (value = token.toLowerCase()).equals("function") || value.equals("unit") || value.equals("module") || value.equals("namespace"))) {
                this.tokenzier.nextToken();
                ScriptElement callelement = new ScriptElement(2, token);
                this.parseParameters(callelement);
                return callelement;
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return new ScriptElement(6, token);
    }

    private void processOperator(List objects, List operators) {
        ScriptElement param;
        int opr = (Integer)operators.remove(operators.size() - 1);
        String oprvalue = (String)this.infixOperators.get(opr);
        ScriptElement right_object = (ScriptElement)objects.remove(objects.size() - 1);
        ScriptElement left_object = (ScriptElement)objects.remove(objects.size() - 1);
        ScriptElement callelement = new ScriptElement(2, oprvalue);
        if (left_object == null) {
            left_object = right_object;
            right_object = null;
        }
        if (left_object != null) {
            param = new ScriptElement(3, "1");
            param.add(left_object);
            callelement.add(param);
        }
        if (right_object != null) {
            param = new ScriptElement(3, "2");
            param.add(right_object);
            callelement.add(param);
        }
        objects.add(callelement);
    }

    private void parseParameters(ScriptElement parent) throws ScriptParserException {
        int paramno = 1;
        while (this.tokenzier.hasMoreTokens()) {
            ScriptElement expression;
            String paramname = null;
            ScriptTokenizer st = this.tokenzier.clone();
            if (st.hasMoreTokens()) {
                String nametoken = st.nextToken();
                if (st.hasMoreTokens() && st.nextToken().equals("=") && !nametoken.equals("(") && !this.infixOperators.contains(nametoken) && (nametoken.length() != 1 || "=+-<>/!*^&(),{};".indexOf(nametoken.charAt(0)) == -1)) {
                    paramname = nametoken.toLowerCase();
                    this.tokenzier.nextToken();
                    this.tokenzier.nextToken();
                }
            }
            if (paramname == null) {
                paramname = Integer.toString(paramno);
                ++paramno;
            }
            if ((expression = this.parseExpression(",)", false)) != null) {
                ScriptElement param = new ScriptElement(3, paramname);
                param.add(expression);
                parent.add(param);
            }
            if (!this.lastendtoken.equals(")")) continue;
            return;
        }
        throw this.makeException(this.index, "Was expecting ')' token.");
    }

    private void parseUnitParameters(ScriptElement parent) throws ScriptParserException {
        while (this.tokenzier.hasMoreTokens()) {
            String token = this.tokenzier.nextToken();
            if (token.equals(")")) {
                return;
            }
            if (this.infixOperators.contains(token)) {
                throw this.makeException(this.index, "Wasn't expecting '" + token + "' token.");
            }
            String paramname = token;
            if (!this.tokenzier.hasMoreTokens()) {
                throw this.makeException(this.index, "Was expecting ')' or ',' token.");
            }
            token = this.tokenzier.nextToken();
            if (token.equals(")") || token.equals(",")) {
                ScriptElement param = new ScriptElement(3, paramname);
                parent.add(param);
                if (token.equals(")")) {
                    return;
                }
                if (token.equals(",")) continue;
            }
            if (!token.equals("=")) {
                throw this.makeException(this.index, "Was expecting ')', ',' or '=' token.");
            }
            ScriptElement expression = this.parseExpression(",)", false);
            if (expression == null) {
                throw this.makeException(this.index, "Was expecting expression.");
            }
            ScriptElement param = new ScriptElement(3, paramname);
            param.add(expression);
            parent.add(param);
            if (!this.lastendtoken.equals(")")) continue;
            return;
        }
        throw this.makeException(this.index, "Was expecting ')' token.");
    }

    /*
     * Unable to fully structure code
     */
    private ScriptElement parseUnit(String unittype) throws ScriptParserException {
        unitobject = new ScriptElement(7, unittype);
        if (unittype.equals("module")) {
            if (!this.tokenzier.hasMoreTokens()) {
                throw this.makeException(this.index, "Was expecting ')' token.");
            }
            token = this.tokenzier.nextToken();
            if (!token.equals(")")) {
                throw this.makeException(this.index, "Was expecting ')' token.");
            }
        } else {
            this.parseUnitParameters(unitobject);
        }
        body = new ScriptElement(0);
        unitobject.add(body);
        if (!this.tokenzier.hasMoreTokens()) {
            throw this.makeException(this.index, "Was expecting '{' token.");
        }
        token = this.tokenzier.nextToken();
        if (token.equals("{")) ** GOTO lbl21
        throw this.makeException(this.index, "Was expecting '{' token.");
lbl-1000:
        // 1 sources

        {
            expression = this.parseExpression(";}", false);
            if (expression != null) {
                body.add(expression);
            }
            if (this.lastendtoken == null || this.lastendtoken.equals("}")) break;
lbl21:
            // 2 sources

            ** while (this.tokenzier.hasMoreTokens())
        }
lbl22:
        // 2 sources

        if (this.lastendtoken == null || !this.lastendtoken.equals("}")) {
            throw this.makeException(this.index, "Was expecting '}' token.");
        }
        return unitobject;
    }

    /*
     * Unable to fully structure code
     */
    private ScriptElement parseExpression(String endtoken, boolean eofok) throws ScriptParserException {
        objects = new ArrayList<ScriptElement>();
        operators = new ArrayList<Integer>();
        nextIsOperator = false;
        eofend = true;
        while (this.tokenzier.hasMoreTokens()) {
            block18: {
                token = this.tokenzier.nextToken();
                this.index = this.tokenzier.lastIndex();
                if (endtoken.indexOf(token) != -1) {
                    this.lastendtoken = token;
                    eofend = false;
                    break;
                }
                if (!nextIsOperator && token.equals("<-")) {
                    objects.add(new ScriptElement(6, "output"));
                    nextIsOperator = true;
                }
                if (!nextIsOperator) break block18;
                if (token.equals("<-")) {
                    if (objects.size() == 0) {
                        throw this.makeException(this.index, "Wasn't expecting '<-' token.");
                    }
                    lastobject = (ScriptElement)objects.get(objects.size() - 1);
                    if (lastobject.getType() == 2) {
                        param = new ScriptElement(3, "input");
                        param.add(this.parseExpression(endtoken, false));
                        lastobject.add(param);
                        eofend = false;
                        break;
                    }
                    if (lastobject.getType() == 6) {
                        objects.remove(objects.size() - 1);
                        assign = new ScriptElement(1, lastobject.getValue());
                        preindex = this.index;
                        expr = this.parseExpression(endtoken, false);
                        if (expr == null) {
                            throw this.makeException(preindex, "Was expecting ';' token.");
                        }
                        assign.add(expr);
                        objects.add(assign);
                        eofend = false;
                        break;
                    }
                    throw this.makeException(this.index, "Wasn't expecting '<-' token.");
                }
                if (token.equals("(")) {
                    lastobject = (ScriptElement)objects.remove(objects.size() - 1);
                    if (lastobject.getType() != 6) {
                        throw this.makeException(this.index, "Wasn't expecting '(' token.");
                    }
                    value = ((String)lastobject.getValue()).toLowerCase();
                    if (value.equals("function") || value.equals("unit") || value.equals("module") || value.equals("namespace")) {
                        unit = this.parseUnit(value);
                        if (unit == null) {
                            throw this.makeException(this.index, "Was expecting unit.");
                        }
                        objects.add(unit);
                        nextIsOperator = true;
                        if (endtoken.indexOf(59) != -1) {
                            this.lastendtoken = ";";
                            eofend = false;
                            break;
                        }
                    }
                    callelement = new ScriptElement(2, lastobject.getValue());
                    this.parseParameters(callelement);
                    objects.add(callelement);
                    nextIsOperator = true;
                    continue;
                }
                tokenorder = this.infixOperators.indexOf(token);
                if (tokenorder != -1) ** GOTO lbl67
                throw this.makeException(this.index, "Was expecting operator.");
lbl-1000:
                // 1 sources

                {
                    this.processOperator(objects, operators);
lbl67:
                    // 2 sources

                    ** while (operators.size() != 0 && ((Integer)operators.get((int)(operators.size() - 1))).intValue() <= tokenorder)
                }
lbl68:
                // 1 sources

                operators.add(tokenorder);
                nextIsOperator = false;
                continue;
            }
            valueelement = this.parseValueToken(token);
            if (valueelement == null) {
                throw this.makeException(this.index, "Was expecting value token.");
            }
            objects.add(valueelement);
            nextIsOperator = true;
        }
        if (objects.size() == 0) {
            return null;
        }
        if (eofend && !eofok) {
            throw this.makeException(this.index, "Was expecting '" + endtoken + "' token.");
        }
        if (nextIsOperator) ** GOTO lbl87
        throw this.makeException(this.index, "Was expecting value token.");
lbl-1000:
        // 1 sources

        {
            this.processOperator(objects, operators);
lbl87:
            // 2 sources

            ** while (operators.size() != 0)
        }
lbl88:
        // 1 sources

        return (ScriptElement)objects.get(0);
    }

    private void parseScript(ScriptElement parent) throws ScriptParserException {
        while (this.tokenzier.hasMoreTokens()) {
            ScriptElement expression = this.parseExpression(";", true);
            if (expression == null) continue;
            parent.add(expression);
        }
    }
}

