/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.parser;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import rasmus.interpreter.Commitable;
import rasmus.interpreter.ExecutableInstance;
import rasmus.interpreter.NameSpace;
import rasmus.interpreter.Variable;
import rasmus.interpreter.namespace.InheritNameSpace;
import rasmus.interpreter.parser.CompiledScript;
import rasmus.interpreter.parser.ScriptUnitFactory;
import rasmus.interpreter.struct.Struct;
import rasmus.interpreter.unit.Parameters;
import rasmus.interpreter.unit.Unit;
import rasmus.interpreter.unit.UnitInstance;

public class ScriptInstance
implements ExecutableInstance {
    private Variable returnvariable;
    private NameSpace namespace;
    private String[] regpriv;
    private Variable[] added;
    private Variable[] scriptunits;
    private ScriptInstance[] interpreters;
    private UnitInstance[] units;
    private InheritNameSpace inheritnamespace = null;

    public ScriptInstance(NameSpace namespace, CompiledScript compiledscript) {
        this.namespace = namespace;
        namespace.addToCommitStack(new NewTask(namespace, compiledscript));
    }

    public Variable getReturnVariable() {
        return this.returnvariable;
    }

    public void close() {
        this.namespace.addToCommitStack(new Commitable(){

            public int getRunLevel() {
                return 0;
            }

            public void commit() {
                int i = 0;
                while (i < ScriptInstance.this.units.length) {
                    ScriptInstance.this.units[i].close();
                    ++i;
                }
                i = 0;
                while (i < ScriptInstance.this.scriptunits.length) {
                    ScriptInstance.this.scriptunits[i].clear();
                    ++i;
                }
                i = 0;
                while (i < ScriptInstance.this.interpreters.length) {
                    ScriptInstance.this.interpreters[i].close();
                    ++i;
                }
                i = 0;
                while (i < ScriptInstance.this.regpriv.length) {
                    ScriptInstance.this.namespace.unRegisterAsPrivate(ScriptInstance.this.regpriv[i]);
                    ++i;
                }
                i = 0;
                while (i < ScriptInstance.this.added.length) {
                    Variable to = ScriptInstance.this.added[i++];
                    Variable from = ScriptInstance.this.added[i++];
                    to.remove(from);
                }
                ScriptInstance.this.regpriv = null;
                ScriptInstance.this.added = null;
                ScriptInstance.this.scriptunits = null;
                ScriptInstance.this.interpreters = null;
                ScriptInstance.this.units = null;
                if (ScriptInstance.this.inheritnamespace != null) {
                    ScriptInstance.this.inheritnamespace.close();
                    ScriptInstance.this.inheritnamespace = null;
                }
            }
        });
    }

    private class NewTask
    implements Commitable {
        String[] private_variabls;
        String[] vardef_Names;
        Variable[] vardef_Constants;
        int[] varadd_to;
        int[] varadd_from;
        int[] varunit;
        List<String>[] varunit_params;
        List<Integer>[] varunit_defaults;
        CompiledScript[] varunit_body;
        int[] varunit_types;
        int[] varcall;
        Map<String, Integer>[] varcall_params;
        String[] varnamespace_name;
        CompiledScript[] varnamespace_body;
        Variable[] variables;

        public NewTask(NameSpace namespace, CompiledScript compiledscript) {
            this.private_variabls = compiledscript.private_variables;
            this.vardef_Names = compiledscript.vardef_Names;
            this.vardef_Constants = compiledscript.vardef_Constants;
            this.varadd_to = compiledscript.varadd_to;
            this.varadd_from = compiledscript.varadd_from;
            this.varunit = compiledscript.varunit;
            this.varunit_params = compiledscript.varunit_params;
            this.varunit_defaults = compiledscript.varunit_defaults;
            this.varunit_body = compiledscript.varunit_body;
            this.varunit_types = compiledscript.varunit_types;
            this.varcall = compiledscript.varcall;
            this.varcall_params = compiledscript.varcall_params;
            this.varnamespace_name = compiledscript.varnamespace_name;
            this.varnamespace_body = compiledscript.varnamespace_body;
            this.variables = new Variable[this.vardef_Names.length];
            int i = 0;
            while (i < this.variables.length) {
                String varname = this.vardef_Names[i];
                Variable constant = this.vardef_Constants[i];
                if (constant != null) {
                    this.variables[i] = constant;
                } else if (varname == null) {
                    this.variables[i] = new Variable();
                } else {
                    StringTokenizer st = new StringTokenizer(varname, ".");
                    Variable var = st.hasMoreTokens() ? namespace.get(st.nextToken()) : new Variable();
                    while (st.hasMoreTokens()) {
                        var = Struct.get(var, st.nextToken());
                    }
                    this.variables[i] = var;
                }
                ++i;
            }
            if (compiledscript.returnVar == -1) {
                ScriptInstance.this.returnvariable = null;
            } else {
                ScriptInstance.this.returnvariable = this.variables[compiledscript.returnVar];
            }
        }

        public int getRunLevel() {
            return 0;
        }

        public void commit() {
            Iterator<Object> iterator;
            int v;
            ScriptInstance.this.regpriv = new String[this.private_variabls.length];
            int i = 0;
            while (i < this.private_variabls.length) {
                String varname = this.private_variabls[i];
                int li = varname.indexOf(".");
                if (li != -1) {
                    varname = varname.substring(0, li);
                }
                ScriptInstance.this.namespace.registerAsPrivate(varname);
                ((ScriptInstance)ScriptInstance.this).regpriv[i] = varname;
                ++i;
            }
            ScriptInstance.this.added = new Variable[(this.varadd_to.length + this.varunit.length) * 2];
            int added_index = 0;
            int i2 = 0;
            while (i2 < this.varadd_to.length) {
                v = this.varadd_to[i2];
                Variable to = this.variables[v];
                Variable from = this.variables[this.varadd_from[i2]];
                to.add(from);
                ((ScriptInstance)ScriptInstance.this).added[added_index++] = to;
                ((ScriptInstance)ScriptInstance.this).added[added_index++] = from;
                ++i2;
            }
            ScriptInstance.this.scriptunits = new Variable[this.varunit.length];
            i2 = 0;
            while (i2 < this.varunit.length) {
                Variable scriptunit;
                v = this.varunit[i2];
                Variable var = this.variables[v];
                iterator = this.varunit_defaults[i2].iterator();
                ArrayList<Variable> defaults = new ArrayList<Variable>(this.varunit_defaults[i2].size());
                while (iterator.hasNext()) {
                    Integer varid = iterator.next();
                    if (varid == null) {
                        defaults.add(null);
                        continue;
                    }
                    defaults.add(this.variables[varid]);
                }
                ScriptUnitFactory factory = new ScriptUnitFactory(this.varunit_params[i2], defaults, this.varunit_body[i2], ScriptInstance.this.namespace, this.varunit_types[i2]);
                ((ScriptInstance)ScriptInstance.this).scriptunits[i2] = scriptunit = Unit.asVariable(factory);
                var.add(scriptunit);
                ((ScriptInstance)ScriptInstance.this).added[added_index++] = var;
                ((ScriptInstance)ScriptInstance.this).added[added_index++] = scriptunit;
                ++i2;
            }
            ScriptInstance.this.interpreters = new ScriptInstance[this.varnamespace_name.length];
            i2 = 0;
            while (i2 < this.varnamespace_name.length) {
                InheritNameSpace inheritnamespace = new InheritNameSpace(ScriptInstance.this.namespace, this.varnamespace_name[i2]);
                ((ScriptInstance)ScriptInstance.this).interpreters[i2] = new ScriptInstance(inheritnamespace, this.varnamespace_body[i2]);
                ScriptInstance.this.interpreters[i2].inheritnamespace = inheritnamespace;
                ++i2;
            }
            ScriptInstance.this.units = new UnitInstance[this.varcall.length];
            i2 = 0;
            while (i2 < this.varcall.length) {
                UnitInstance unitinstance;
                Variable var = this.variables[this.varcall[i2]];
                Map<String, Integer> params = this.varcall_params[i2];
                iterator = params.entrySet().iterator();
                Parameters uparams = new Parameters(ScriptInstance.this.namespace);
                while (iterator.hasNext()) {
                    Map.Entry entry = (Map.Entry)iterator.next();
                    String pname = (String)entry.getKey();
                    Variable pvar = this.variables[(Integer)entry.getValue()];
                    uparams.setParameter(pname, pvar);
                }
                ((ScriptInstance)ScriptInstance.this).units[i2] = unitinstance = Unit.newInstance(var, uparams);
                ++i2;
            }
        }
    }
}

