/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.parser;

import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptElement {
    public static final int TYPE_BODY = 0;
    public static final int TYPE_ASSIGNMENT = 1;
    public static final int TYPE_CALL = 2;
    public static final int TYPE_PARAMETER = 3;
    public static final int TYPE_STRING = 4;
    public static final int TYPE_NUMBER = 5;
    public static final int TYPE_IDENTIFIER = 6;
    public static final int TYPE_UNIT = 7;
    private static List typelist = new ArrayList();
    private int type = 0;
    private Object value = null;
    private ArrayList<ScriptElement> elements = null;

    static {
        typelist.add("body");
        typelist.add("assignment");
        typelist.add("call");
        typelist.add("parameter");
        typelist.add("string");
        typelist.add("number");
        typelist.add("identifier");
        typelist.add("unit");
    }

    public List<ScriptElement> getElements() {
        return this.elements;
    }

    public Object getValue() {
        return this.value;
    }

    public int getType() {
        return this.type;
    }

    public ScriptElement(int type, Object value) {
        this.type = type;
        this.value = value;
    }

    public ScriptElement(int type) {
        this.type = type;
    }

    public void add(ScriptElement element) {
        if (this.elements == null) {
            this.elements = new ArrayList();
        }
        if (element == null) {
            throw new NullPointerException();
        }
        this.elements.add(element);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        this.toString(sb, 0);
        return sb.toString();
    }

    private void toString(StringBuffer sb, int ident) {
        int i = 0;
        while (i < ident) {
            sb.append(' ');
            ++i;
        }
        sb.append(typelist.get(this.type) + ": ");
        if (this.value != null) {
            sb.append(this.value);
        }
        sb.append('\n');
        if (this.elements != null) {
            for (ScriptElement childelement : this.elements) {
                childelement.toString(sb, ident + 3);
            }
        }
    }

    public String toXML() {
        StringBuffer sb = new StringBuffer();
        this.toXML(sb, 0);
        return sb.toString();
    }

    private void toXML(StringBuffer sb, int ident) {
        int i = 0;
        while (i < ident) {
            sb.append(' ');
            ++i;
        }
        sb.append("<" + typelist.get(this.type));
        if (this.value != null) {
            sb.append(" value='" + this.value.toString() + "'");
        }
        if (this.elements != null) {
            sb.append(">");
            sb.append('\n');
            for (ScriptElement childelement : this.elements) {
                childelement.toXML(sb, ident + 3);
            }
            int i2 = 0;
            while (i2 < ident) {
                sb.append(' ');
                ++i2;
            }
            sb.append("</" + typelist.get(this.type) + ">");
            sb.append('\n');
        } else {
            sb.append("/>");
            sb.append('\n');
        }
    }
}

