/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.parser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import rasmus.interpreter.Executable;
import rasmus.interpreter.Variable;
import rasmus.interpreter.list.ObjectsPart;
import rasmus.interpreter.math.DoublePart;
import rasmus.interpreter.parser.CompiledScript;
import rasmus.interpreter.parser.ScriptElement;
import rasmus.interpreter.parser.ScriptOptimizer;
import rasmus.interpreter.parser.ScriptParser;
import rasmus.interpreter.parser.ScriptParserException;

public class ScriptCompiler {
    private int varcounter = 0;
    private List c_adds = new ArrayList();
    private List c_radds = new ArrayList();
    private List c_calls = new ArrayList();
    private List c_namespaces = new ArrayList();
    private List c_units = new ArrayList();
    private ArrayList privatevariables = new ArrayList();
    private HashMap<String, Integer> namespace = new HashMap();

    public static Executable compile(String script) throws ScriptParserException {
        return ScriptCompiler.compile(ScriptOptimizer.optimize(ScriptParser.parse(script)));
    }

    public static Executable compile(ScriptElement script) {
        ScriptCompiler compiler = new ScriptCompiler();
        Integer ret = compiler.eval(script);
        CompiledScript co = compiler.getCompiledScript();
        if (ret != null) {
            co.returnVar = ret;
        }
        return co;
    }

    private Integer newVariable() {
        int varid = this.varcounter++;
        return varid;
    }

    private Integer getVariable(String name) {
        Integer var = this.namespace.get(name);
        if (var == null) {
            var = this.newVariable();
            this.namespace.put(name, var);
        }
        return var;
    }

    /*
     * WARNING - void declaration
     */
    private CompiledScript getCompiledScript() {
        CompiledScript cs = new CompiledScript();
        cs.private_variables = new String[this.privatevariables.size()];
        Iterator<Object> iterator = this.privatevariables.iterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            void var3_4;
            cs.private_variables[var3_4] = (String)iterator.next();
            ++var3_4;
        }
        cs.vardef_Names = new String[this.varcounter];
        Arrays.fill(cs.vardef_Names, null);
        for (Map.Entry entry : this.namespace.entrySet()) {
            int varid = (Integer)entry.getValue();
            cs.vardef_Names[varid] = (String)entry.getKey();
        }
        cs.vardef_Constants = new Variable[this.varcounter];
        Arrays.fill(cs.vardef_Constants, null);
        iterator = this.c_radds.iterator();
        boolean bl2 = false;
        while (iterator.hasNext()) {
            void var3_7;
            Object[] entry = (Object[])iterator.next();
            cs.vardef_Constants[((Integer)entry[0]).intValue()] = (Variable)entry[1];
            ++var3_7;
        }
        cs.varadd_to = new int[this.c_adds.size()];
        cs.varadd_from = new int[this.c_adds.size()];
        iterator = this.c_adds.iterator();
        boolean bl3 = false;
        while (iterator.hasNext()) {
            void var3_9;
            int[] entry = (int[])iterator.next();
            cs.varadd_to[var3_9] = entry[0];
            cs.varadd_from[var3_9] = entry[1];
            ++var3_9;
        }
        cs.varunit = new int[this.c_units.size()];
        cs.varunit_params = new List[this.c_units.size()];
        cs.varunit_body = new CompiledScript[this.c_units.size()];
        cs.varunit_defaults = new List[this.c_units.size()];
        cs.varunit_types = new int[this.c_units.size()];
        iterator = this.c_units.iterator();
        boolean bl4 = false;
        while (iterator.hasNext()) {
            void var3_11;
            Object[] entry = (Object[])iterator.next();
            cs.varunit[var3_11] = (Integer)entry[0];
            cs.varunit_params[var3_11] = (List)entry[1];
            cs.varunit_body[var3_11] = (CompiledScript)entry[2];
            cs.varunit_defaults[var3_11] = (List)entry[3];
            cs.varunit_types[var3_11] = (Integer)entry[4];
            ++var3_11;
        }
        cs.varcall = new int[this.c_calls.size()];
        cs.varcall_params = new Map[this.c_calls.size()];
        iterator = this.c_calls.iterator();
        boolean bl5 = false;
        while (iterator.hasNext()) {
            void var3_13;
            Object[] entry = (Object[])iterator.next();
            cs.varcall[var3_13] = (Integer)entry[0];
            Map map = (Map)entry[1];
            for (Map.Entry mentry : map.entrySet()) {
                map.put(mentry.getKey(), (Integer)mentry.getValue());
            }
            cs.varcall_params[var3_13] = map;
            ++var3_13;
        }
        cs.varnamespace_name = new String[this.c_namespaces.size()];
        cs.varnamespace_body = new CompiledScript[this.c_namespaces.size()];
        iterator = this.c_namespaces.iterator();
        boolean bl6 = false;
        while (iterator.hasNext()) {
            void var3_15;
            Object[] entry = (Object[])iterator.next();
            cs.varnamespace_name[var3_15] = (String)entry[0];
            cs.varnamespace_body[var3_15] = (CompiledScript)entry[1];
            ++var3_15;
        }
        return cs;
    }

    private Integer evalBody(ScriptElement element) {
        List<ScriptElement> elements = element.getElements();
        if (elements == null) {
            return null;
        }
        Integer ret = null;
        for (ScriptElement child : elements) {
            Integer r = this.eval(child);
            if (r == null) continue;
            ret = r;
        }
        return ret;
    }

    private Integer evalNumber(ScriptElement element) {
        Integer varid = this.newVariable();
        Object[] item = new Object[]{varid, DoublePart.asVariable((Double)element.getValue())};
        this.c_radds.add(item);
        return varid;
    }

    private Integer evalString(ScriptElement element) {
        Integer varid = this.newVariable();
        Object[] item = new Object[]{varid, ObjectsPart.asVariable((String)element.getValue())};
        this.c_radds.add(item);
        return varid;
    }

    private Integer evalIdentifier(ScriptElement element) {
        return this.getVariable((String)element.getValue());
    }

    private Integer evalAssignment(ScriptElement element) {
        if (element.getElements() != null && element.getElements().size() == 1) {
            int[] item = new int[]{this.getVariable((String)element.getValue()), this.eval(element.getElements().get(0))};
            this.c_adds.add(item);
            String name = (String)element.getValue();
            name = name.toLowerCase();
            if (!this.privatevariables.contains(name)) {
                this.privatevariables.add(name);
            }
            return item[1];
        }
        return null;
    }

    private Integer evalCall(ScriptElement element) {
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        if (element.getElements() != null) {
            for (ScriptElement param_element : element.getElements()) {
                Integer paramvalue;
                if (param_element.getType() != 3) continue;
                String paramname = (String)param_element.getValue();
                if (param_element.getElements() == null || param_element.getElements().size() != 1 || (paramvalue = this.eval(param_element.getElements().get(0))) == null) continue;
                params.put(paramname, paramvalue);
            }
        }
        Integer retvar = this.newVariable();
        if (element.getValue().equals("+")) {
            for (Integer paramvalue : params.values()) {
                int[] item = new int[]{retvar, paramvalue};
                this.c_adds.add(item);
            }
        } else {
            params.put("output", retvar);
            Object[] item = new Object[]{this.getVariable((String)element.getValue()), params};
            this.c_calls.add(item);
        }
        return retvar;
    }

    private Integer evalUnit(ScriptElement element) {
        ScriptElement param1;
        ArrayList<ScriptElement> parameters = new ArrayList<ScriptElement>();
        Iterator<ScriptElement> citerator = element.getElements().iterator();
        ScriptElement body = null;
        while (citerator.hasNext()) {
            ScriptElement param_element = citerator.next();
            if (param_element.getType() == 3) {
                parameters.add(param_element);
                continue;
            }
            if (param_element.getType() != 0) continue;
            body = param_element;
        }
        if (body == null) {
            return null;
        }
        if (element.getValue().equals("function") || element.getValue().equals("unit") || element.getValue().equals("module")) {
            ArrayList<String> unitparamslist = new ArrayList<String>();
            ArrayList<Integer> unitdefaults = new ArrayList<Integer>();
            if (element.getValue().equals("unit") || element.getValue().equals("function")) {
                unitparamslist.add("output");
                unitdefaults.add(null);
            }
            for (ScriptElement parm_element : parameters) {
                Integer vret;
                unitparamslist.add((String)parm_element.getValue());
                Integer defval = null;
                if (parm_element.getElements() != null && parm_element.getElements().size() == 1 && (vret = this.eval(parm_element.getElements().get(0))) != null) {
                    defval = vret;
                }
                unitdefaults.add(defval);
            }
            Integer var = this.newVariable();
            int unit_type = 0;
            if (element.getValue().equals("module")) {
                unit_type = 1;
            }
            Object[] item = new Object[]{var, unitparamslist, ScriptCompiler.compile(body), unitdefaults, new Integer(unit_type)};
            this.c_units.add(item);
            return var;
        }
        if (element.getValue().equals("namespace") && parameters.size() == 1 && (param1 = (ScriptElement)parameters.get(0)).getType() == 3) {
            String namespace = (String)param1.getValue();
            Object[] item = new Object[]{namespace, ScriptCompiler.compile(body)};
            this.c_namespaces.add(item);
        }
        return null;
    }

    private Integer eval(ScriptElement element) {
        switch (element.getType()) {
            case 0: {
                return this.evalBody(element);
            }
            case 5: {
                return this.evalNumber(element);
            }
            case 4: {
                return this.evalString(element);
            }
            case 6: {
                return this.evalIdentifier(element);
            }
            case 1: {
                return this.evalAssignment(element);
            }
            case 2: {
                return this.evalCall(element);
            }
            case 7: {
                return this.evalUnit(element);
            }
        }
        return null;
    }
}

