/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.namespace;

import rasmus.interpreter.Closeable;
import rasmus.interpreter.NameSpace;
import rasmus.interpreter.NameSpaceAdapter;
import rasmus.interpreter.Variable;
import rasmus.interpreter.struct.Struct;

public class InheritNameSpace
extends NameSpaceAdapter
implements Closeable {
    private NameSpace parent;
    private Variable parentvar;
    private Variable var;
    private Struct struct;
    private String namespacename = null;

    public InheritNameSpace(NameSpace parent) {
        this.parent = parent;
        this.parentvar = parent.get("this");
        this.var = new Variable();
        this.struct = Struct.getInstance(this.var);
        this.struct.put("parent", this.parentvar);
        this.struct.put("global", parent.get("global"));
        this.struct.add(this.parentvar);
        this.struct.setCommitSystem(Struct.getInstance(this.parentvar).getCommitSystem());
        this.setNameSpace(this.struct);
    }

    public InheritNameSpace(NameSpace parent, String namespacename) {
        this.namespacename = namespacename;
        this.parent = parent;
        this.parentvar = parent.get("this");
        this.var = new Variable();
        this.struct = Struct.getInstance(this.var);
        this.struct.put("parent", this.parentvar);
        this.struct.put("global", parent.get("global"));
        this.struct.add(this.parentvar);
        this.struct.setCommitSystem(Struct.getInstance(this.parentvar).getCommitSystem());
        this.setNameSpace(this.struct);
        if (namespacename != null) {
            parent.get(namespacename).add(this.var);
        }
    }

    public void put(String name, Variable var) {
        this.struct.put(name.toLowerCase(), var);
    }

    public void close() {
        if (this.namespacename != null) {
            this.parent.get(this.namespacename).remove(this.var);
        }
        this.struct.remove(this.parentvar);
    }
}

