/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.namespace;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Enumeration;
import rasmus.interpreter.Interpreter;
import rasmus.interpreter.NameSpace;
import rasmus.interpreter.Variable;
import rasmus.interpreter.ext.ExternalJava;
import rasmus.interpreter.io.ResourceManager;
import rasmus.interpreter.list.ObjectsPart;
import rasmus.interpreter.namespace.CommitSystem;
import rasmus.interpreter.parser.ScriptParserException;
import rasmus.interpreter.spi.InterpreterExtension;
import rasmus.interpreter.struct.Struct;
import rasmus.interpreter.unit.Unit;

public class GlobalNameSpace {
    private static Struct global_namespace;
    private static Interpreter global_interpreter;
    static /* synthetic */ Class class$0;

    public static Struct newInstance() {
        Struct global_namespace;
        block16: {
            global_namespace = Struct.getInstance(new Variable());
            global_namespace.setCommitSystem(new CommitSystem());
            global_namespace.put("global", global_namespace.get("this"));
            global_interpreter = new Interpreter(global_namespace);
            global_interpreter.setAutoCommit(false);
            try {
                global_interpreter.add("sysdir", ObjectsPart.asVariable(String.valueOf(new File(".").getCanonicalPath()) + File.separator));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ResourceManager.getInstance(global_interpreter);
            global_interpreter.add("ExternalJava", Unit.asVariable(new ExternalJava()));
            global_interpreter.commit();
            try {
                Enumeration<URL> extenum = Interpreter.class.getClassLoader().getResources("META-INF/services/rasmus.interpreter.spi.InterpreterExtension");
                while (extenum.hasMoreElements()) {
                    InputStream extstream = extenum.nextElement().openStream();
                    BufferedReader r = new BufferedReader(new InputStreamReader(extstream));
                    String line = r.readLine();
                    while (line != null) {
                        if (!line.startsWith("#")) {
                            try {
                                Class<?> c = Class.forName(line.trim());
                                Object o = c.newInstance();
                                if (o instanceof InterpreterExtension) {
                                    InterpreterExtension oie = (InterpreterExtension)o;
                                    oie.execute(global_interpreter);
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        line = r.readLine();
                    }
                    extstream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                File[] files = new File("ext").listFiles();
                if (files == null) break block16;
                int i = 0;
                while (i < files.length) {
                    File file = files[i];
                    if (file.isFile() && file.getName().toLowerCase().endsWith(".r")) {
                        try {
                            global_interpreter.source(file.getPath());
                        }
                        catch (ScriptParserException e) {
                            e.printStackTrace();
                        }
                    }
                    ++i;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        global_interpreter.commit();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                global_interpreter.close();
                global_interpreter = null;
            }
        });
        return global_namespace;
    }

    public static NameSpace getNameSpace() {
        if (global_namespace == null) {
            global_namespace = GlobalNameSpace.newInstance();
        }
        return global_namespace;
    }
}

