/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.midi.modifiers;

import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.ShortMessage;
import rasmus.interpreter.Variable;
import rasmus.interpreter.math.DoublePart;
import rasmus.interpreter.midi.modifiers.MidiFilterAdapter;
import rasmus.interpreter.unit.Parameters;

class MidiTransposeInstance
extends MidiFilterAdapter {
    Variable transpose;
    int miditranspose = 0;

    public MidiEvent processEvent(MidiEvent midievent) {
        ShortMessage omsg;
        int cmd;
        MidiMessage msg = midievent.getMessage();
        if (msg instanceof ShortMessage && ((cmd = (omsg = (ShortMessage)msg).getCommand()) == 144 || cmd == 128)) {
            ShortMessage smsg = new ShortMessage();
            try {
                int data1 = omsg.getData1() + this.miditranspose;
                if (data1 > 128) {
                    return null;
                }
                smsg.setMessage(cmd, omsg.getChannel(), data1, omsg.getData2());
            }
            catch (InvalidMidiDataException e) {
                System.out.println(e.toString());
            }
            msg = smsg;
        }
        long tick = midievent.getTick();
        MidiEvent rmidievent = new MidiEvent(msg, tick);
        return rmidievent;
    }

    public void calc() {
        this.miditranspose = (int)DoublePart.asDouble(this.transpose);
        super.calc();
    }

    public MidiTransposeInstance(Parameters parameters) {
        super(parameters.getNameSpace());
        this.output = parameters.getParameterWithDefault("output");
        this.input = parameters.getParameterWithDefault(2, "input");
        this.transpose = parameters.getParameterWithDefault(1, "amount");
        DoublePart.getInstance(this.transpose).addListener(this);
        this.registerInput(this.input);
        this.calc();
    }

    public void close() {
        super.close();
        DoublePart.getInstance(this.transpose).removeListener(this);
        this.clear();
    }
}

