/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.midi.modifiers;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.TreeMap;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.Receiver;
import javax.sound.midi.ShortMessage;
import rasmus.interpreter.Commitable;
import rasmus.interpreter.NameSpace;
import rasmus.interpreter.Variable;
import rasmus.interpreter.list.ListPart;
import rasmus.interpreter.list.ListPartListener;
import rasmus.interpreter.midi.MidiSequence;
import rasmus.interpreter.unit.Parameters;
import rasmus.interpreter.unit.UnitInstanceAdapter;

class MidiMonoNotesInstance
extends UnitInstanceAdapter
implements Commitable {
    public Variable output;
    public Variable input;
    public Receiver recv = null;
    public Variable answer = null;
    MidiSequence midiseq;
    public boolean answer_added = true;
    Comparator<MidiEvent> midieventcomparator = new Comparator<MidiEvent>(){

        @Override
        public int compare(MidiEvent arg0, MidiEvent arg1) {
            long comp = arg0.getTick() - arg1.getTick();
            if (comp > 0L) {
                return 1;
            }
            if (comp < 0L) {
                return -1;
            }
            return 0;
        }
    };
    TreeMap<MidiEvent, MidiEvent> stop_events = new TreeMap(this.midieventcomparator);
    ArrayList<CommitEvent> events = new ArrayList();
    boolean in_commit_need = false;
    boolean is_committing = false;
    int addeventcount = 0;
    RListListenerAndRecv midilistener = new RListListenerAndRecv();
    NameSpace namespace;

    public void clear() {
        this.events.clear();
        this.stop_events.clear();
        if (this.answer != null) {
            this.output.remove(this.answer);
            this.answer_added = false;
        }
    }

    public int getRunLevel() {
        return 0;
    }

    public void commit() {
        if (!this.in_commit_need) {
            return;
        }
        this.in_commit_need = false;
        this.is_committing = true;
        int insize = MidiSequence.getInstance(this.input).getObjects().size();
        if (insize == 0) {
            this.stop_events.clear();
            if (this.answer_added) {
                this.output.remove(this.answer);
                this.answer = new Variable();
                this.midiseq = MidiSequence.getInstance(this.answer);
                this.answer_added = false;
            }
            this.events.clear();
            this.stop_events.clear();
            this.is_committing = false;
            this.addeventcount = 0;
            return;
        }
        if (this.addeventcount == insize) {
            this.events.clear();
            this.stop_events.clear();
            this.is_committing = false;
            this.addeventcount = 0;
            this.calc();
            return;
        }
        for (CommitEvent event : this.events) {
            if (event.removeEvent) {
                this.c_removeEvent(event.midievent);
                continue;
            }
            this.c_addEvent(event.midievent);
        }
        this.events.clear();
        if (!this.answer_added) {
            this.output.add(this.answer);
        }
        this.is_committing = false;
        this.addeventcount = 0;
    }

    public void addEvent(MidiEvent midievent) {
        ++this.addeventcount;
        if (this.is_committing) {
            throw new Error("Circual Reference Error !!!!");
        }
        if (!this.in_commit_need) {
            this.in_commit_need = true;
            this.namespace.addToCommitStack(this);
        }
        CommitEvent event = new CommitEvent();
        event.midievent = midievent;
        event.removeEvent = false;
        this.events.add(event);
    }

    public void removeEvent(MidiEvent midievent) {
        if (!this.in_commit_need) {
            this.in_commit_need = true;
            this.namespace.addToCommitStack(this);
        }
        CommitEvent event = new CommitEvent();
        event.midievent = midievent;
        event.removeEvent = true;
        this.events.add(event);
    }

    public void c_addEvent(MidiEvent midievent) {
        ShortMessage smidimessage;
        MidiMessage midimessage = midievent.getMessage();
        if (midimessage instanceof ShortMessage && ((smidimessage = (ShortMessage)midimessage).getCommand() == 144 && smidimessage.getData2() > 0 || smidimessage.getCommand() == 128 && smidimessage.getData1() == 0)) {
            try {
                MidiEvent nextmidievent = this.stop_events.tailMap(midievent).firstKey();
                if (nextmidievent != null) {
                    long nexttick = nextmidievent.getTick();
                    try {
                        ShortMessage smsg = new ShortMessage();
                        smsg.setMessage(128, ((ShortMessage)midievent.getMessage()).getChannel(), ((ShortMessage)midievent.getMessage()).getData1(), 0);
                        MidiEvent stopevent = new MidiEvent(smsg, nexttick - 1L);
                        this.stop_events.put(midievent, stopevent);
                        this.midiseq.addObject(stopevent);
                    }
                    catch (InvalidMidiDataException e) {
                        e.printStackTrace();
                    }
                }
            }
            catch (NoSuchElementException e) {
                this.stop_events.put(midievent, midievent);
            }
            try {
                MidiEvent prevmidievent = this.stop_events.headMap(midievent).lastKey();
                if (prevmidievent != null) {
                    long curtick = midievent.getTick();
                    MidiEvent stopevent = this.stop_events.get(prevmidievent);
                    if (stopevent == prevmidievent) {
                        try {
                            ShortMessage smsg = new ShortMessage();
                            smsg.setMessage(128, ((ShortMessage)midievent.getMessage()).getChannel(), ((ShortMessage)prevmidievent.getMessage()).getData1(), 0);
                            stopevent = new MidiEvent(smsg, curtick - 1L);
                            this.stop_events.put(prevmidievent, stopevent);
                            this.midiseq.addObject(stopevent);
                        }
                        catch (InvalidMidiDataException e) {
                            e.printStackTrace();
                        }
                    } else {
                        this.midiseq.removeObject(stopevent);
                        stopevent.setTick(curtick - 1L);
                        this.midiseq.addObject(stopevent);
                    }
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
        }
        this.midiseq.addObject(midievent);
    }

    public void c_removeEvent(MidiEvent midievent) {
        ShortMessage smidimessage;
        MidiMessage midimessage = midievent.getMessage();
        if (midimessage instanceof ShortMessage && ((smidimessage = (ShortMessage)midimessage).getCommand() == 144 && smidimessage.getData2() > 0 || smidimessage.getCommand() == 128 && smidimessage.getData1() == 0)) {
            MidiEvent nextmidievent = null;
            MidiEvent prevmidievent = null;
            MidiEvent stopevent = this.stop_events.get(midievent);
            if (stopevent != null) {
                this.midiseq.removeObject(stopevent);
                this.stop_events.remove(midievent);
            }
            try {
                prevmidievent = this.stop_events.headMap(midievent).lastKey();
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
            try {
                nextmidievent = this.stop_events.tailMap(midievent).firstKey();
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
            if (prevmidievent != null && (stopevent = this.stop_events.get(prevmidievent)) != prevmidievent) {
                if (nextmidievent == null) {
                    this.midiseq.removeObject(stopevent);
                    this.stop_events.remove(prevmidievent);
                } else {
                    this.midiseq.removeObject(stopevent);
                    stopevent.setTick(nextmidievent.getTick() - 1L);
                    this.midiseq.addObject(stopevent);
                }
            }
        }
        this.midiseq.removeObject(midievent);
    }

    public void calc() {
        this.clear();
        if (this.answer != null && this.answer_added) {
            this.output.remove(this.answer);
        }
        this.answer_added = true;
        this.answer = new Variable();
        this.midiseq = MidiSequence.getInstance(this.answer);
        List events = MidiSequence.getInstance(this.input).getObjects();
        for (MidiEvent element : events) {
            this.c_addEvent(element);
        }
        this.output.add(this.answer);
    }

    public ListPartListener getMidiListener() {
        return this.midilistener;
    }

    public MidiMonoNotesInstance(Parameters parameters) {
        this.namespace = parameters.getNameSpace();
        this.output = parameters.getParameterWithDefault("output");
        this.input = parameters.getParameterWithDefault(1, "input");
        MidiSequence.getInstance(this.input).addListener(this.getMidiListener());
        this.calc();
    }

    public void close() {
        this.in_commit_need = false;
        MidiSequence.getInstance(this.input).removeListener(this);
        this.clear();
    }

    class CommitEvent {
        boolean removeEvent = false;
        MidiEvent midievent;

        CommitEvent() {
        }
    }

    class RListListenerAndRecv
    implements ListPartListener,
    Receiver {
        RListListenerAndRecv() {
        }

        public void objectAdded(ListPart source, Object object) {
            MidiEvent element = (MidiEvent)object;
            MidiMonoNotesInstance.this.addEvent(element);
        }

        public void objectRemoved(ListPart source, Object object) {
            MidiMonoNotesInstance.this.removeEvent((MidiEvent)object);
        }

        public void objectsAdded(ListPart source, List objects) {
            Iterator iterator = objects.iterator();
            while (iterator.hasNext()) {
                this.objectAdded(source, iterator.next());
            }
        }

        public void objectsRemoved(ListPart source, List objects) {
            Iterator iterator = objects.iterator();
            while (iterator.hasNext()) {
                this.objectRemoved(source, iterator.next());
            }
        }

        public void send(MidiMessage message, long timeStamp) {
            if (MidiMonoNotesInstance.this.recv == null) {
                MidiMonoNotesInstance.this.recv = MidiSequence.getInstance(MidiMonoNotesInstance.this.output);
            }
            if (message != null) {
                MidiMonoNotesInstance.this.recv.send(message, timeStamp);
            }
        }

        public void close() {
        }
    }
}

