/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.midi.modifiers;

import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.ShortMessage;
import rasmus.interpreter.Variable;
import rasmus.interpreter.math.DoublePart;
import rasmus.interpreter.midi.MidiSequence;
import rasmus.interpreter.midi.modifiers.MidiFilterAdapter;
import rasmus.interpreter.unit.Parameters;

class MidiModifyMessagesInstance
extends MidiFilterAdapter {
    long mididpos = 0L;
    Variable command = null;
    Variable commandadd = null;
    Variable commandmul = null;
    Variable channel = null;
    Variable channeladd = null;
    Variable channelmul = null;
    Variable data1 = null;
    Variable data1add = null;
    Variable data1mul = null;
    Variable data2 = null;
    Variable data2add = null;
    Variable data2mul = null;
    Variable pos2 = null;
    Variable pos2add = null;
    Variable pos2mul = null;
    double f_command = 0.0;
    double f_commandadd = 0.0;
    double f_commandmul = 1.0;
    double f_channel = 0.0;
    double f_channeladd = 0.0;
    double f_channelmul = 1.0;
    double f_data1 = 0.0;
    double f_data1add = 0.0;
    double f_data1mul = 1.0;
    double f_data2 = 0.0;
    double f_data2add = 0.0;
    double f_data2mul = 1.0;
    double f_pos2 = 0.0;
    double f_pos2add = 0.0;
    double f_pos2mul = 1.0;

    public MidiEvent processEvent(MidiEvent midievent) {
        MidiMessage msg = midievent.getMessage();
        if (msg instanceof ShortMessage) {
            ShortMessage ssmg = (ShortMessage)msg;
            ShortMessage ssmg2 = new ShortMessage();
            int mcmd = ssmg.getCommand();
            int mchannel = ssmg.getChannel();
            int mdata1 = ssmg.getData1();
            int mdata2 = ssmg.getData2();
            if (this.command != null) {
                mcmd = (int)this.f_command;
            }
            if (this.channel != null) {
                mchannel = (int)this.f_channel;
            }
            if (this.data1 != null) {
                mdata1 = (int)this.f_data1;
            }
            if (this.data2 != null) {
                mdata2 = (int)this.f_data2;
            }
            mcmd = (int)((double)mcmd * this.f_commandmul + this.f_commandadd);
            mchannel = (int)((double)mchannel * this.f_channelmul + this.f_channeladd);
            mdata1 = (int)((double)mdata1 * this.f_data1mul + this.f_data1add);
            mdata2 = (int)((double)mdata2 * this.f_data2mul + this.f_data2add);
            try {
                ssmg2.setMessage(mcmd, mchannel, mdata1, mdata2);
            }
            catch (InvalidMidiDataException e) {
                System.out.println(e);
            }
            msg = ssmg2;
        }
        long tick = midievent.getTick();
        if (this.pos2 != null) {
            tick = (int)this.f_pos2;
        }
        tick = (int)((double)tick * this.f_pos2mul + this.f_pos2add);
        return new MidiEvent(msg, tick);
    }

    public void calc() {
        if (this.command != null) {
            this.f_command = DoublePart.asDouble(this.command);
        }
        if (this.commandadd != null) {
            this.f_commandadd = DoublePart.asDouble(this.commandadd);
        }
        if (this.commandmul != null) {
            this.f_commandmul = DoublePart.asDouble(this.commandmul);
        }
        if (this.channel != null) {
            this.f_channel = DoublePart.asDouble(this.channel);
            if (this.f_channel != 0.0) {
                this.f_channel -= 1.0;
            }
        }
        if (this.channeladd != null) {
            this.f_channeladd = DoublePart.asDouble(this.channeladd);
        }
        if (this.channelmul != null) {
            this.f_channelmul = DoublePart.asDouble(this.channelmul);
        }
        if (this.data1 != null) {
            this.f_data1 = DoublePart.asDouble(this.data1);
        }
        if (this.data1add != null) {
            this.f_data1add = DoublePart.asDouble(this.data1add);
        }
        if (this.data1mul != null) {
            this.f_data1mul = DoublePart.asDouble(this.data1mul);
        }
        if (this.data2 != null) {
            this.f_data2 = DoublePart.asDouble(this.data2);
        }
        if (this.data2add != null) {
            this.f_data2add = DoublePart.asDouble(this.data2add);
        }
        if (this.data2mul != null) {
            this.f_data2mul = DoublePart.asDouble(this.data2mul);
        }
        if (this.pos2 != null) {
            this.f_pos2 = DoublePart.asDouble(this.pos2) * (double)MidiSequence.DEFAULT_RES;
        }
        if (this.pos2add != null) {
            this.f_pos2add = DoublePart.asDouble(this.pos2add) * (double)MidiSequence.DEFAULT_RES;
        }
        if (this.pos2mul != null) {
            this.f_pos2mul = DoublePart.asDouble(this.pos2mul) * (double)MidiSequence.DEFAULT_RES;
        }
        super.calc();
    }

    public MidiModifyMessagesInstance(Parameters parameters) {
        super(parameters.getNameSpace());
        this.output = parameters.getParameterWithDefault("output");
        this.input = parameters.getParameterWithDefault("input");
        this.command = parameters.getParameter("command");
        this.commandadd = parameters.getParameter("commandadd");
        this.commandmul = parameters.getParameter("commandmul");
        this.channel = parameters.getParameter("channel");
        this.channeladd = parameters.getParameter("channeladd");
        this.channelmul = parameters.getParameter("channelnot");
        this.data1 = parameters.getParameter("data1");
        this.data1add = parameters.getParameter("data1add");
        this.data1mul = parameters.getParameter("data1mul");
        this.data2 = parameters.getParameter("data2");
        this.data2add = parameters.getParameter("data2add");
        this.data2mul = parameters.getParameter("data2mul");
        this.pos2 = parameters.getParameter("pos");
        this.pos2add = parameters.getParameter("posadd");
        this.pos2mul = parameters.getParameter("posmul");
        if (this.command != null) {
            DoublePart.getInstance(this.command).addListener(this);
        }
        if (this.commandadd != null) {
            DoublePart.getInstance(this.commandadd).addListener(this);
        }
        if (this.commandmul != null) {
            DoublePart.getInstance(this.commandmul).addListener(this);
        }
        if (this.channel != null) {
            DoublePart.getInstance(this.channel).addListener(this);
        }
        if (this.channeladd != null) {
            DoublePart.getInstance(this.channeladd).addListener(this);
        }
        if (this.channelmul != null) {
            DoublePart.getInstance(this.channelmul).addListener(this);
        }
        if (this.data1 != null) {
            DoublePart.getInstance(this.data1).addListener(this);
        }
        if (this.data1add != null) {
            DoublePart.getInstance(this.data1add).addListener(this);
        }
        if (this.data1mul != null) {
            DoublePart.getInstance(this.data1mul).addListener(this);
        }
        if (this.data2 != null) {
            DoublePart.getInstance(this.data2).addListener(this);
        }
        if (this.data2add != null) {
            DoublePart.getInstance(this.data2add).addListener(this);
        }
        if (this.data2mul != null) {
            DoublePart.getInstance(this.data2mul).addListener(this);
        }
        if (this.pos2 != null) {
            DoublePart.getInstance(this.pos2).addListener(this);
        }
        if (this.pos2add != null) {
            DoublePart.getInstance(this.pos2add).addListener(this);
        }
        if (this.pos2mul != null) {
            DoublePart.getInstance(this.pos2mul).addListener(this);
        }
        this.registerInput(this.input);
        this.calc();
    }

    public void close() {
        super.close();
        if (this.command != null) {
            DoublePart.getInstance(this.command).removeListener(this);
        }
        if (this.commandadd != null) {
            DoublePart.getInstance(this.commandadd).removeListener(this);
        }
        if (this.commandmul != null) {
            DoublePart.getInstance(this.commandmul).removeListener(this);
        }
        if (this.channel != null) {
            DoublePart.getInstance(this.channel).removeListener(this);
        }
        if (this.channeladd != null) {
            DoublePart.getInstance(this.channeladd).removeListener(this);
        }
        if (this.channelmul != null) {
            DoublePart.getInstance(this.channelmul).removeListener(this);
        }
        if (this.data1 != null) {
            DoublePart.getInstance(this.data1).removeListener(this);
        }
        if (this.data1add != null) {
            DoublePart.getInstance(this.data1add).removeListener(this);
        }
        if (this.data1mul != null) {
            DoublePart.getInstance(this.data1mul).removeListener(this);
        }
        if (this.data2 != null) {
            DoublePart.getInstance(this.data2).removeListener(this);
        }
        if (this.data2add != null) {
            DoublePart.getInstance(this.data2add).removeListener(this);
        }
        if (this.data2mul != null) {
            DoublePart.getInstance(this.data2mul).removeListener(this);
        }
        if (this.pos2 != null) {
            DoublePart.getInstance(this.pos2).removeListener(this);
        }
        if (this.pos2add != null) {
            DoublePart.getInstance(this.pos2add).removeListener(this);
        }
        if (this.pos2mul != null) {
            DoublePart.getInstance(this.pos2mul).removeListener(this);
        }
        this.clear();
    }
}

