/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.midi.modifiers;

import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.ShortMessage;
import rasmus.interpreter.Variable;
import rasmus.interpreter.math.DoublePart;
import rasmus.interpreter.midi.modifiers.MidiFilterAdapter;
import rasmus.interpreter.unit.Parameters;

class MidiFilterNotesInstance
extends MidiFilterAdapter {
    Variable keyFrom = null;
    Variable keyTo = null;
    Variable velFrom = null;
    Variable velTo = null;
    int f_keyFrom = -1;
    int f_keyTo = -1;
    int f_velFrom = -1;
    int f_velTo = -1;

    public MidiEvent processEvent(MidiEvent midievent) {
        ShortMessage smsg;
        int cmd;
        MidiMessage msg = midievent.getMessage();
        if (msg instanceof ShortMessage && ((cmd = (smsg = (ShortMessage)msg).getCommand()) == 144 || cmd == 128)) {
            if (cmd == 144 && smsg.getData2() > 0) {
                if (this.f_keyFrom != -1 && smsg.getData1() < this.f_keyFrom) {
                    return null;
                }
                if (this.f_keyTo != -1 && smsg.getData1() > this.f_keyTo) {
                    return null;
                }
                if (this.f_velFrom != -1 && smsg.getData2() < this.f_velFrom) {
                    return null;
                }
                if (this.f_velTo != -1 && smsg.getData2() > this.f_velTo) {
                    return null;
                }
            }
            return midievent;
        }
        return null;
    }

    public void calc() {
        this.f_keyFrom = -1;
        this.f_keyTo = -1;
        this.f_velFrom = -1;
        this.f_velTo = -1;
        if (this.keyFrom != null) {
            this.f_keyFrom = (int)DoublePart.asDouble(this.keyFrom);
        }
        if (this.keyTo != null) {
            this.f_keyTo = (int)DoublePart.asDouble(this.keyTo);
        }
        if (this.velFrom != null) {
            this.f_velFrom = (int)DoublePart.asDouble(this.velFrom);
        }
        if (this.velTo != null) {
            this.f_velTo = (int)DoublePart.asDouble(this.velTo);
        }
    }

    public MidiFilterNotesInstance(Parameters parameters) {
        super(parameters.getNameSpace());
        this.output = parameters.getParameterWithDefault("output");
        this.input = parameters.getParameterWithDefault("input");
        this.keyFrom = parameters.getParameter(1, "keyFrom");
        this.keyTo = parameters.getParameter(2, "keyTo");
        this.velFrom = parameters.getParameter(3, "velFrom");
        this.velTo = parameters.getParameter(4, "velTo");
        if (this.keyFrom != null) {
            DoublePart.getInstance(this.keyFrom).addListener(this);
        }
        if (this.keyTo != null) {
            DoublePart.getInstance(this.keyTo).addListener(this);
        }
        if (this.velFrom != null) {
            DoublePart.getInstance(this.velFrom).addListener(this);
        }
        if (this.velTo != null) {
            DoublePart.getInstance(this.velTo).addListener(this);
        }
        this.registerInput(this.input);
        this.calc();
    }

    public void close() {
        super.close();
        if (this.keyFrom != null) {
            DoublePart.getInstance(this.keyFrom).removeListener(this);
        }
        if (this.keyTo != null) {
            DoublePart.getInstance(this.keyTo).removeListener(this);
        }
        if (this.velFrom != null) {
            DoublePart.getInstance(this.velFrom).removeListener(this);
        }
        if (this.velTo != null) {
            DoublePart.getInstance(this.velTo).removeListener(this);
        }
        this.clear();
    }
}

