/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.midi.modifiers;

import java.util.ArrayList;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.Sequence;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Track;
import rasmus.interpreter.Variable;
import rasmus.interpreter.math.DoublePart;
import rasmus.interpreter.midi.MidiSequence;
import rasmus.interpreter.midi.modifiers.MidiFilterAdapter;
import rasmus.interpreter.unit.Parameters;

class MidiExtractInstance
extends MidiFilterAdapter {
    Variable from;
    Variable to;
    Variable answer;
    long midifrom = 0L;
    long midito = 0L;
    boolean filtermidito = true;

    public MidiEvent processEvent(MidiEvent midievent) {
        long tick = midievent.getTick();
        if (this.filtermidito ? tick < this.midifrom || tick > this.midito : tick < this.midifrom) {
            return null;
        }
        return new MidiEvent(midievent.getMessage(), tick - this.midifrom);
    }

    public void calc() {
        this.midifrom = (long)((double)MidiSequence.DEFAULT_RES * DoublePart.asDouble(this.from));
        if (this.to == null) {
            this.midito = 0L;
            this.filtermidito = false;
        } else {
            this.filtermidito = true;
            this.midito = (long)((double)MidiSequence.DEFAULT_RES * DoublePart.asDouble(this.to));
            if (this.midito == 0L) {
                this.filtermidito = false;
            }
        }
        super.calc();
        if (!this.filtermidito) {
            return;
        }
        if (this.answer != null) {
            this.output.remove(this.answer);
        }
        this.answer = null;
        Sequence sq = MidiSequence.asSequence(this.input);
        Track[] tracks = sq.getTracks();
        MidiSequence manswer = null;
        ArrayList[] ch = new ArrayList[16];
        int i = 0;
        while (i < ch.length) {
            ch[i] = new ArrayList();
            ++i;
        }
        i = 0;
        while (i < tracks.length) {
            Track track = tracks[i];
            int len = track.size();
            int j = 0;
            while (j < len) {
                MidiEvent event = track.get(j);
                MidiMessage msg = event.getMessage();
                long tick = event.getTick();
                if (tick >= this.midifrom && tick <= this.midito && msg instanceof ShortMessage) {
                    ShortMessage smsg = (ShortMessage)msg;
                    int cmd = smsg.getCommand();
                    int channel = smsg.getChannel();
                    int data1 = smsg.getData1();
                    if (cmd == 144) {
                        if (smsg.getData2() != 0) {
                            ch[channel].add(new Integer(data1));
                        } else {
                            ch[channel].remove(new Integer(data1));
                        }
                    } else if (cmd == 128) {
                        ch[channel].remove(new Integer(data1));
                    }
                }
                ++j;
            }
            j = 0;
            while (j < ch.length) {
                if (ch[j].size() != 0) {
                    if (this.answer == null) {
                        this.answer = new Variable();
                        manswer = MidiSequence.getInstance(this.answer);
                    }
                    for (Integer note : ch[j]) {
                        ShortMessage msg = new ShortMessage();
                        try {
                            msg.setMessage(144, j, note, 0);
                            MidiEvent midievent = new MidiEvent(msg, this.midito - this.midifrom);
                            manswer.addObject(midievent);
                        }
                        catch (InvalidMidiDataException e) {
                            e.printStackTrace();
                        }
                    }
                    ch[j].clear();
                }
                ++j;
            }
            ++i;
        }
        if (this.answer != null) {
            this.output.add(this.answer);
        }
    }

    public MidiExtractInstance(Parameters parameters) {
        super(parameters.getNameSpace());
        this.output = parameters.getParameterWithDefault("output");
        this.from = parameters.getParameterWithDefault(1, "from");
        this.to = parameters.getParameterWithDefault(2, "to");
        this.input = parameters.getParameterWithDefault(3, "input");
        DoublePart.getInstance(this.from).addListener(this);
        if (this.to != null) {
            DoublePart.getInstance(this.to).addListener(this);
        }
        this.registerInput(this.input);
        this.calc();
    }

    public void close() {
        super.close();
        DoublePart.getInstance(this.from).removeListener(this);
        if (this.to != null) {
            DoublePart.getInstance(this.to).removeListener(this);
        }
        if (this.answer != null) {
            this.output.remove(this.answer);
        }
        this.answer = null;
        this.clear();
    }
}

