/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.midi.io;

import java.util.ArrayList;
import java.util.Map;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiSystem;
import rasmus.interpreter.metadata.MetaData;
import rasmus.interpreter.metadata.MetaDataProvider;
import rasmus.interpreter.midi.io.MidiOutputInstance;
import rasmus.interpreter.unit.Parameters;
import rasmus.interpreter.unit.UnitFactory;
import rasmus.interpreter.unit.UnitInstancePart;

public class MidiOutput
implements UnitFactory,
MetaDataProvider {
    public MetaData getMetaData() {
        MetaData metadata = new MetaData("Midi Output");
        Map map = metadata.add(1, "devname", "Device name", null, null, 2, 1);
        ArrayList<String> options = new ArrayList<String>();
        map.put("options", options);
        MidiDevice.Info[] devinfo = MidiSystem.getMidiDeviceInfo();
        int i = 0;
        while (i < devinfo.length) {
            try {
                MidiDevice mididev = MidiSystem.getMidiDevice(devinfo[i]);
                if (mididev.getReceiver() != null) {
                    options.add("\"" + devinfo[i].getName() + "\"");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
        metadata.add(-1, "input", "Input", null, null, 4, 1);
        return metadata;
    }

    public UnitInstancePart newInstance(Parameters parameters) {
        return new MidiOutputInstance(parameters);
    }
}

