/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.midi.io;

import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Receiver;
import rasmus.interpreter.Variable;
import rasmus.interpreter.list.ObjectsPart;
import rasmus.interpreter.midi.MidiSequence;
import rasmus.interpreter.unit.Parameters;
import rasmus.interpreter.unit.UnitInstanceAdapter;

class MidiInputInstance
extends UnitInstanceAdapter {
    Receiver output;
    Variable devname;
    MidiDevice midiindev = null;

    public void clear() {
        if (this.midiindev != null) {
            this.midiindev.close();
            this.midiindev = null;
        }
    }

    public void calc() {
        this.clear();
        String s_devname = ObjectsPart.toString(this.devname);
        if (s_devname.length() == 0) {
            return;
        }
        MidiDevice.Info[] devinfo = MidiSystem.getMidiDeviceInfo();
        MidiDevice.Info midimapdev = null;
        int i = 0;
        while (i < devinfo.length) {
            if (devinfo[i].getName().equals(s_devname)) {
                midimapdev = devinfo[i];
                try {
                    this.midiindev = MidiSystem.getMidiDevice(midimapdev);
                    this.midiindev.open();
                    this.midiindev.getTransmitter().setReceiver(this.output);
                    return;
                }
                catch (Exception e) {
                    try {
                        this.midiindev.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            ++i;
        }
    }

    public MidiInputInstance(Parameters parameters) {
        Variable output = parameters.getParameterWithDefault(0, "output");
        this.devname = parameters.getParameterWithDefault(1, "devname");
        this.output = MidiSequence.getInstance(output);
        ObjectsPart.getInstance(this.devname).addListener(this);
        this.calc();
    }

    public void close() {
        ObjectsPart.getInstance(this.devname).removeListener(this);
        this.clear();
    }
}

