/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.midi.io;

import java.util.ArrayList;
import java.util.Map;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiSystem;
import rasmus.interpreter.metadata.MetaData;
import rasmus.interpreter.metadata.MetaDataProvider;
import rasmus.interpreter.midi.io.MidiInputInstance;
import rasmus.interpreter.unit.Parameters;
import rasmus.interpreter.unit.UnitFactory;
import rasmus.interpreter.unit.UnitInstancePart;

public class MidiInput
implements UnitFactory,
MetaDataProvider {
    public MetaData getMetaData() {
        MetaData metadata = new MetaData("Midi Input");
        metadata.add(-1, "output", "Output", null, null, 4, 2);
        Map map = metadata.add(1, "devname", "Device name", null, null, 2, 1);
        ArrayList<String> options = new ArrayList<String>();
        map.put("options", options);
        MidiDevice.Info[] devinfo = MidiSystem.getMidiDeviceInfo();
        int i = 0;
        while (i < devinfo.length) {
            try {
                MidiDevice mididev = MidiSystem.getMidiDevice(devinfo[i]);
                if (mididev.getTransmitter() != null) {
                    options.add("\"" + devinfo[i].getName() + "\"");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
        return metadata;
    }

    public UnitInstancePart newInstance(Parameters parameters) {
        return new MidiInputInstance(parameters);
    }
}

