/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.midi.generators;

import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.ShortMessage;
import rasmus.interpreter.Variable;
import rasmus.interpreter.math.DoublePart;
import rasmus.interpreter.midi.MidiSequence;
import rasmus.interpreter.unit.Parameters;
import rasmus.interpreter.unit.UnitInstanceAdapter;

class MidiNoteInstance
extends UnitInstanceAdapter {
    Variable output;
    Variable answer = null;
    Variable note;
    Variable vel;
    Variable ch;
    Variable pos;

    public void clear() {
        if (this.answer != null) {
            this.output.remove(this.answer);
            this.answer = null;
        }
    }

    public void calc() {
        this.clear();
        this.answer = new Variable();
        MidiSequence midiseq = MidiSequence.getInstance(this.answer);
        midiseq.setImmutable(true);
        int i_ch = (int)DoublePart.asDouble(this.ch);
        int i_note = (int)DoublePart.asDouble(this.note);
        int i_vel = (int)DoublePart.asDouble(this.vel);
        ShortMessage smsg = new ShortMessage();
        try {
            smsg.setMessage(144, i_ch, i_note, i_vel);
            long tick = (long)((double)MidiSequence.DEFAULT_RES * DoublePart.asDouble(this.pos));
            MidiEvent midievent = new MidiEvent(smsg, tick);
            midiseq.addObject(midievent);
            this.output.add(this.answer);
        }
        catch (InvalidMidiDataException e) {
            System.out.println(e);
        }
    }

    public MidiNoteInstance(Parameters parameters) {
        this.output = parameters.getParameterWithDefault("output");
        this.note = parameters.getParameterWithDefault(1, "note");
        this.vel = parameters.getParameterWithDefault(2, "vel");
        this.ch = parameters.getParameterWithDefault(3, "ch");
        this.pos = parameters.getParameterWithDefault(4, "pos");
        DoublePart.getInstance(this.note).addListener(this);
        DoublePart.getInstance(this.vel).addListener(this);
        DoublePart.getInstance(this.ch).addListener(this);
        DoublePart.getInstance(this.pos).addListener(this);
        this.calc();
    }

    public void close() {
        DoublePart.getInstance(this.note).removeListener(this);
        DoublePart.getInstance(this.vel).removeListener(this);
        DoublePart.getInstance(this.ch).removeListener(this);
        DoublePart.getInstance(this.pos).removeListener(this);
        this.clear();
    }
}

