/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.midi.generators;

import java.util.List;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.ShortMessage;
import rasmus.interpreter.Commitable;
import rasmus.interpreter.NameSpace;
import rasmus.interpreter.Variable;
import rasmus.interpreter.list.ObjectsPart;
import rasmus.interpreter.midi.MidiSequence;
import rasmus.interpreter.unit.Parameters;
import rasmus.interpreter.unit.UnitInstanceAdapter;
import rasmus.util.ABCTokenizer;

class MidiABCNotationInstance
extends UnitInstanceAdapter
implements Commitable {
    Variable output;
    Variable answer = null;
    Variable input;
    String midiNoteSymbols = "C D EF G A Bc d ef g a b";
    int parse_function_type = 0;
    int parse_function_subtype = 0;
    NameSpace namespace;

    public void clear() {
        if (this.answer != null) {
            this.output.remove(this.answer);
            this.answer = null;
        }
    }

    public void calc() {
        this.namespace.addToCommitStack(this);
    }

    public void parse(MidiSequence midiseq, ABCTokenizer.ABCToken token) {
        int midinote = this.midiNoteSymbols.indexOf(token.symbol);
        if (midinote != -1) {
            MidiEvent midievent;
            ShortMessage smsg;
            midinote += token.octave * 12;
            midinote += token.accidentals;
            long tick = (long)((double)MidiSequence.DEFAULT_RES * token.pos);
            long endtick = (long)((double)MidiSequence.DEFAULT_RES * (token.pos + token.len));
            int i_ch = token.channel;
            if (i_ch < 1) {
                i_ch = 1;
            }
            if (i_ch > 16) {
                i_ch = 16;
            }
            int i_note = midinote;
            int i_vel = token.velocity;
            try {
                smsg = new ShortMessage();
                smsg.setMessage(144, i_ch - 1, i_note, i_vel);
                midievent = new MidiEvent(smsg, tick);
                midiseq.addObject(midievent);
            }
            catch (InvalidMidiDataException e) {
                System.out.println(e);
            }
            try {
                smsg = new ShortMessage();
                smsg.setMessage(128, i_ch - 1, i_note, 0);
                midievent = new MidiEvent(smsg, endtick);
                midiseq.addObject(midievent);
            }
            catch (InvalidMidiDataException e) {
                System.out.println(e);
            }
        }
    }

    public void parse(MidiSequence midiseq, ABCTokenizer.CommandToken token) {
        long tick = (long)((double)MidiSequence.DEFAULT_RES * token.pos);
        int i_ch = token.channel;
        if (token.fieldname.equals("f")) {
            if (token.fieldvalue.equalsIgnoreCase("p")) {
                this.parse_function_type = 1;
            } else if (token.fieldvalue.length() > 0 && Character.isDigit(token.fieldvalue.charAt(0))) {
                try {
                    this.parse_function_type = 2;
                    this.parse_function_subtype = Integer.parseInt(token.fieldvalue);
                }
                catch (Throwable throwable) {}
            }
        } else if (token.fieldname.equals("d")) {
            try {
                switch (this.parse_function_type) {
                    case 1: {
                        double d_v = Double.parseDouble(token.fieldvalue);
                        int v = (int)((d_v + 100.0) * 8192.0);
                        if (v > 16256) {
                            v = 16256;
                        }
                        if (v < 0) {
                            v = 0;
                        }
                        ShortMessage smsg = new ShortMessage();
                        smsg.setMessage(224, i_ch - 1, v % 128, v / 128);
                        MidiEvent midievent = new MidiEvent(smsg, tick);
                        midiseq.addObject(midievent);
                        break;
                    }
                    case 2: {
                        int v = Integer.parseInt(token.fieldvalue);
                        if (v > 127) {
                            v = 127;
                        }
                        if (v < 0) {
                            v = 0;
                        }
                        ShortMessage smsg = new ShortMessage();
                        smsg.setMessage(176, i_ch - 1, this.parse_function_subtype, v);
                        MidiEvent midievent = new MidiEvent(smsg, tick);
                        midiseq.addObject(midievent);
                        break;
                    }
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        } else if (token.fieldname.equals("i")) {
            try {
                MidiEvent midievent;
                ShortMessage smsg;
                String program = token.fieldvalue;
                String bank = null;
                int li = token.fieldvalue.indexOf(",");
                if (li != -1) {
                    bank = program.substring(li + 1);
                    program = program.substring(0, li);
                }
                if (bank != null) {
                    int i_bank = Integer.parseInt(bank);
                    if (i_bank < 0) {
                        i_bank = 0;
                    }
                    if (i_bank > 16256) {
                        i_bank = 16256;
                    }
                    int m_bank = i_bank / 128;
                    smsg = new ShortMessage();
                    smsg.setMessage(176, i_ch - 1, 0, m_bank);
                    midievent = new MidiEvent(smsg, tick);
                    midiseq.addObject(midievent);
                    int l_bank = i_bank % 128;
                    smsg = new ShortMessage();
                    smsg.setMessage(176, i_ch - 1, 32, l_bank);
                    midievent = new MidiEvent(smsg, tick);
                    midiseq.addObject(midievent);
                }
                int i_program = Integer.parseInt(program);
                smsg = new ShortMessage();
                smsg.setMessage(192, i_ch - 1, i_program, 0);
                midievent = new MidiEvent(smsg, tick);
                midiseq.addObject(midievent);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public int getRunLevel() {
        return 0;
    }

    public void commit() {
        this.clear();
        this.answer = new Variable();
        ABCTokenizer abcparser = new ABCTokenizer();
        List tokens = abcparser.parse(ObjectsPart.toString(this.input));
        MidiSequence midiseq = MidiSequence.getInstance(this.answer);
        midiseq.setImmutable(true);
        for (Object token : tokens) {
            if (token instanceof ABCTokenizer.ABCToken) {
                this.parse(midiseq, (ABCTokenizer.ABCToken)token);
                continue;
            }
            if (!(token instanceof ABCTokenizer.CommandToken)) continue;
            this.parse(midiseq, (ABCTokenizer.CommandToken)token);
        }
        this.output.add(this.answer);
    }

    public MidiABCNotationInstance(Parameters parameters) {
        this.namespace = parameters.getNameSpace();
        this.output = parameters.getParameterWithDefault("output");
        this.input = parameters.getParameterWithDefault(1, "input");
        ObjectsPart.getInstance(this.input).addListener(this);
        this.calc();
    }

    public void close() {
        ObjectsPart.getInstance(this.input).removeListener(this);
        this.clear();
    }
}

