/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.midi;

import javax.sound.midi.MidiMessage;
import javax.sound.midi.Receiver;
import javax.sound.midi.ShortMessage;
import rasmus.interpreter.Commitable;
import rasmus.interpreter.NameSpace;
import rasmus.interpreter.Variable;
import rasmus.interpreter.math.DoublePart;
import rasmus.interpreter.midi.MidiSequence;
import rasmus.interpreter.unit.Parameters;
import rasmus.interpreter.unit.UnitInstancePart;

class MidiSwitchInstance
implements UnitInstancePart,
Receiver {
    Variable output;
    Variable input;
    Variable control;
    Variable autostart;
    boolean active = false;
    NameSpace namespace;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        MidiSwitchInstance midiSwitchInstance = this;
        synchronized (midiSwitchInstance) {
            if (this.active) {
                return;
            }
            this.active = true;
            this.output.add(this.input);
            this.namespace.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        MidiSwitchInstance midiSwitchInstance = this;
        synchronized (midiSwitchInstance) {
            if (!this.active) {
                return;
            }
            this.active = false;
            this.output.remove(this.input);
            this.namespace.commit();
        }
    }

    public MidiSwitchInstance(Parameters parameters) {
        this.namespace = parameters.getNameSpace();
        this.output = parameters.getParameterWithDefault("output");
        this.input = parameters.getParameterWithDefault("input");
        this.control = parameters.getParameterWithDefault(1, "control");
        this.autostart = parameters.getParameter(2, "autostart");
        MidiSequence.getInstance(this.control).addReceiver(this);
        this.namespace.addToCommitStack(new Commitable(){

            public int getRunLevel() {
                return 0;
            }

            public void commit() {
                if (MidiSwitchInstance.this.autostart != null && (int)DoublePart.asDouble(MidiSwitchInstance.this.autostart) == 1 && !MidiSwitchInstance.this.active) {
                    MidiSwitchInstance.this.active = true;
                    MidiSwitchInstance.this.output.add(MidiSwitchInstance.this.input);
                }
            }
        });
    }

    public void close() {
        this.stop();
        MidiSequence.getInstance(this.control).removeReceiver(this);
    }

    public void send(MidiMessage arg0, long arg1) {
        if (arg0 instanceof ShortMessage) {
            ShortMessage sms = (ShortMessage)arg0;
            if (sms.getStatus() == 250) {
                this.start();
            }
            if (sms.getStatus() == 252) {
                this.stop();
            }
        }
    }
}

