/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.midi;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.LinkedList;
import java.util.List;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.Receiver;
import javax.sound.midi.ShortMessage;

public class MidiKeyListener
implements KeyListener {
    private List<Integer> keyinside = new LinkedList<Integer>();
    private Receiver recv;
    private int currentvelocity = 100;
    private int currentoctave = 3;
    private LinkedList<Integer> noteinside = new LinkedList();

    public int getVelocity() {
        return this.currentvelocity;
    }

    public int getOctave() {
        return this.currentoctave;
    }

    public void setVelocity(int value) {
        this.currentvelocity = value;
    }

    public void setOctave(int value) {
        this.currentoctave = value;
    }

    public boolean isConsumed(KeyEvent e) {
        return this.keyCodeToNote(e) != 0;
    }

    private int keyCodeToNote(KeyEvent e) {
        return this.keyCodeToNote(this.currentoctave, e);
    }

    private int keyCodeToNote(int currentoctave, KeyEvent e) {
        block52: {
            int note;
            int keycode;
            block51: {
                keycode = e.getKeyCode();
                if (keycode != 0) break block51;
                char keychar = e.getKeyChar();
                switch (keychar) {
                    case '\u00e6': {
                        note = 15;
                        break block52;
                    }
                    case '\u00c6': {
                        note = 15;
                        break block52;
                    }
                    case '\u00fe': {
                        note = 16;
                        break block52;
                    }
                    case '\u00de': {
                        note = 16;
                        break block52;
                    }
                    case '\u00f0': {
                        note = 29;
                        break block52;
                    }
                    case '\u00d0': {
                        note = 29;
                        break block52;
                    }
                    default: {
                        return 0;
                    }
                }
            }
            switch (keycode) {
                case 49: {
                    note = 11;
                    break;
                }
                case 81: {
                    note = 12;
                    break;
                }
                case 50: {
                    note = 13;
                    break;
                }
                case 87: {
                    note = 14;
                    break;
                }
                case 51: {
                    note = 15;
                    break;
                }
                case 52: {
                    note = 17;
                    break;
                }
                case 69: {
                    note = 16;
                    break;
                }
                case 82: {
                    note = 17;
                    break;
                }
                case 53: {
                    note = 18;
                    break;
                }
                case 84: {
                    note = 19;
                    break;
                }
                case 54: {
                    note = 20;
                    break;
                }
                case 89: {
                    note = 21;
                    break;
                }
                case 55: {
                    note = 22;
                    break;
                }
                case 56: {
                    note = 24;
                    break;
                }
                case 85: {
                    note = 23;
                    break;
                }
                case 73: {
                    note = 24;
                    break;
                }
                case 57: {
                    note = 25;
                    break;
                }
                case 79: {
                    note = 26;
                    break;
                }
                case 48: {
                    note = 27;
                    break;
                }
                case 80: {
                    note = 28;
                    break;
                }
                case 45: {
                    note = 30;
                    break;
                }
                case 222: {
                    note = 31;
                    break;
                }
                case 70: {
                    note = -1;
                    break;
                }
                case 153: {
                    note = -1;
                    break;
                }
                case 90: {
                    note = 0;
                    break;
                }
                case 83: {
                    note = 1;
                    break;
                }
                case 88: {
                    note = 2;
                    break;
                }
                case 68: {
                    note = 3;
                    break;
                }
                case 65: {
                    note = 5;
                    break;
                }
                case 67: {
                    note = 4;
                    break;
                }
                case 86: {
                    note = 5;
                    break;
                }
                case 71: {
                    note = 6;
                    break;
                }
                case 66: {
                    note = 7;
                    break;
                }
                case 72: {
                    note = 8;
                    break;
                }
                case 78: {
                    note = 9;
                    break;
                }
                case 74: {
                    note = 10;
                    break;
                }
                case 75: {
                    note = 12;
                    break;
                }
                case 77: {
                    note = 11;
                    break;
                }
                case 44: {
                    note = 12;
                    break;
                }
                case 76: {
                    note = 13;
                    break;
                }
                case 46: {
                    note = 14;
                    break;
                }
                default: {
                    return 0;
                }
            }
        }
        return note += currentoctave * 12;
    }

    public void allNotesOff() {
        for (Integer pnote : this.noteinside) {
            ShortMessage ssmg = new ShortMessage();
            try {
                ssmg.setMessage(144, 0, pnote, 0);
            }
            catch (InvalidMidiDataException e1) {
                e1.printStackTrace();
            }
            if (this.recv == null) continue;
            this.recv.send(ssmg, 0L);
        }
        this.noteinside.clear();
        this.keyinside.clear();
    }

    public void setReceiver(Receiver recv) {
        this.recv = recv;
    }

    public void keyPressed(KeyEvent e) {
        int note;
        ShortMessage ssmg;
        if (e.getKeyCode() == 121) {
            System.gc();
            System.runFinalization();
        }
        if (e.getKeyCode() == 122) {
            ssmg = new ShortMessage();
            try {
                ssmg.setMessage(176, 0, 121, 0);
            }
            catch (InvalidMidiDataException e1) {
                e1.printStackTrace();
            }
            if (this.recv != null) {
                this.recv.send(ssmg, 0L);
            }
        }
        if (e.getKeyCode() == 123) {
            ssmg = new ShortMessage();
            try {
                ssmg.setMessage(176, 0, 120, 0);
            }
            catch (InvalidMidiDataException e1) {
                e1.printStackTrace();
            }
            if (this.recv != null) {
                this.recv.send(ssmg, 0L);
            }
        }
        if (e.getKeyCode() == 27) {
            ssmg = new ShortMessage();
            try {
                ssmg.setMessage(176, 0, 123, 0);
            }
            catch (InvalidMidiDataException e1) {
                e1.printStackTrace();
            }
            if (this.recv != null) {
                this.recv.send(ssmg, 0L);
            }
        }
        if (e.getKeyChar() == '+') {
            ssmg = new ShortMessage();
            try {
                ssmg.setMessage(176, 0, 64, 64);
            }
            catch (InvalidMidiDataException e1) {
                e1.printStackTrace();
            }
            if (this.recv != null) {
                this.recv.send(ssmg, 0L);
            }
        }
        if (e.getKeyChar() == '-') {
            ssmg = new ShortMessage();
            try {
                ssmg.setMessage(176, 0, 64, 63);
            }
            catch (InvalidMidiDataException e1) {
                e1.printStackTrace();
            }
            if (this.recv != null) {
                this.recv.send(ssmg, 0L);
            }
        }
        if (e.getKeyChar() == '*') {
            ssmg = new ShortMessage();
            try {
                ssmg.setMessage(176, 0, 66, 64);
            }
            catch (InvalidMidiDataException e1) {
                e1.printStackTrace();
            }
            if (this.recv != null) {
                this.recv.send(ssmg, 0L);
            }
        }
        if (e.getKeyChar() == '/') {
            ssmg = new ShortMessage();
            try {
                ssmg.setMessage(176, 0, 66, 63);
            }
            catch (InvalidMidiDataException e1) {
                e1.printStackTrace();
            }
            if (this.recv != null) {
                this.recv.send(ssmg, 0L);
            }
        }
        if ((note = this.keyCodeToNote(e)) == 0) {
            return;
        }
        e.consume();
        Integer inote = new Integer(note);
        if (!this.keyinside.contains(inote)) {
            this.keyinside.add(inote);
            ShortMessage ssmg2 = new ShortMessage();
            try {
                this.noteinside.add(inote);
                ssmg2.setMessage(144, 0, note, this.getVelocity());
            }
            catch (InvalidMidiDataException e1) {
                e1.printStackTrace();
            }
            if (this.recv != null) {
                this.recv.send(ssmg2, 0L);
            }
        }
    }

    public void keyReleased(KeyEvent e) {
        int note = this.keyCodeToNote(e);
        if (note == 0) {
            return;
        }
        e.consume();
        this.keyinside.remove(new Integer(note));
        ShortMessage ssmg = new ShortMessage();
        try {
            this.noteinside.remove(new Integer(note));
            ssmg.setMessage(144, 0, note, 0);
        }
        catch (InvalidMidiDataException e1) {
            e1.printStackTrace();
        }
        if (this.recv != null) {
            this.recv.send(ssmg, 0L);
        }
    }

    public void keyTyped(KeyEvent e) {
        int note = this.keyCodeToNote(e);
        if (note == 0) {
            return;
        }
        e.consume();
    }
}

