/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.math;

import rasmus.interpreter.NameSpace;
import rasmus.interpreter.ext.Module;
import rasmus.interpreter.ext.ModuleFactory;
import rasmus.interpreter.math.CondOperator;
import rasmus.interpreter.math.DoubleOperator;
import rasmus.interpreter.math.Scale;
import rasmus.interpreter.math.Sum;
import rasmus.interpreter.unit.UnitInstancePart;

public class MathModule
extends ModuleFactory {
    public UnitInstancePart newInstance(NameSpace namespace) {
        return new ModuleInstance(namespace);
    }

    class ModuleInstance
    extends Module {
        public ModuleInstance(NameSpace namespace) {
            this.setNameSpace(namespace);
            this.add("+", new Sum());
            this.add("*", new DoubleOperator(0));
            this.add("/", new DoubleOperator(1));
            this.add("-", new DoubleOperator(2));
            this.add("mod", new DoubleOperator(4));
            this.add(">", new DoubleOperator(5));
            this.add("<", new DoubleOperator(6));
            this.add(">=", new DoubleOperator(7));
            this.add("<=", new DoubleOperator(8));
            this.add("!=", new DoubleOperator(9));
            this.add("=", new DoubleOperator(10));
            this.add("?", new CondOperator());
            this.add("if", new CondOperator());
            this.add("random", new DoubleOperator(50));
            this.add("abs", new DoubleOperator(100));
            this.add("acos", new DoubleOperator(101));
            this.add("asin", new DoubleOperator(102));
            this.add("atan", new DoubleOperator(103));
            this.add("ceil", new DoubleOperator(104));
            this.add("nativecos", new DoubleOperator(105));
            this.add("fastcos", new DoubleOperator(105));
            this.add("cos", new DoubleOperator(105));
            this.add("exp", new DoubleOperator(106));
            this.add("floor", new DoubleOperator(107));
            this.add("log", new DoubleOperator(108));
            this.add("rint", new DoubleOperator(109));
            this.add("round", new DoubleOperator(110));
            this.add("nativesin", new DoubleOperator(111));
            this.add("fastsin", new DoubleOperator(111));
            this.add("sin", new DoubleOperator(111));
            this.add("sqrt", new DoubleOperator(112));
            this.add("nativetan", new DoubleOperator(113));
            this.add("fasttan", new DoubleOperator(113));
            this.add("tan", new DoubleOperator(113));
            this.add("toDegrees", new DoubleOperator(114));
            this.add("toRadians", new DoubleOperator(115));
            this.add("sgn", new DoubleOperator(116));
            this.add("IEEEremainder", new DoubleOperator(200));
            this.add("atan2", new DoubleOperator(201));
            this.add("max", new DoubleOperator(202));
            this.add("min", new DoubleOperator(203));
            this.add("pow", new DoubleOperator(204));
            this.add("^", new DoubleOperator(204));
            this.add("PI", Math.PI);
            this.add("E", Math.E);
            this.add("true", 1.0f);
            this.add("false", 0.0f);
            this.add("scale", new Scale());
        }
    }
}

