/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.math;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import rasmus.interpreter.Variable;
import rasmus.interpreter.VariablePartAdapter;
import rasmus.interpreter.math.DoublePartListener;

public final class DoublePart
extends VariablePartAdapter
implements DoublePartListener {
    private double value = 0.0;
    private boolean immutable = false;
    ArrayList dependvar;
    public List listeners;
    static /* synthetic */ Class class$0;

    public boolean isImmutable() {
        return this.immutable;
    }

    public static Variable asVariable(double value) {
        DoublePart rfloat = new DoublePart(true);
        rfloat.value = value;
        return new Variable(rfloat);
    }

    public DoublePart() {
        this.dependvar = new ArrayList();
        this.listeners = new ArrayList();
    }

    public DoublePart(boolean immutable) {
        if (immutable) {
            this.immutable = true;
        } else {
            this.dependvar = new ArrayList();
            this.listeners = new ArrayList();
        }
    }

    public static double asDouble(Variable variable) {
        if (variable == null) {
            return 0.0;
        }
        return ((DoublePart)variable.get(DoublePart.class)).getDouble();
    }

    public static DoublePart getInstance(Variable variable) {
        return (DoublePart)variable.get(DoublePart.class);
    }

    private void addFloat(double value) {
        double beforevalue = this.value;
        this.value += value;
        this.sendValueChanged(beforevalue, this.value);
    }

    public double getDouble() {
        return this.value;
    }

    public void add(Variable variable) {
        if (this.dependvar == null) {
            return;
        }
        double beforevalue = this.value;
        DoublePart source = (DoublePart)variable.get(DoublePart.class);
        this.value += source.getDouble();
        this.sendValueChanged(beforevalue, this.value);
        if (!this.immutable) {
            source.addListener(this);
        }
        this.dependvar.add(source);
    }

    public void remove(Variable variable) {
        if (this.dependvar == null) {
            return;
        }
        double beforevalue = this.value;
        DoublePart source = (DoublePart)variable.get(DoublePart.class);
        this.value -= source.getDouble();
        this.sendValueChanged(beforevalue, this.value);
        if (!this.immutable) {
            source.removeListener(this);
        }
        this.dependvar.remove(source);
    }

    public void clear() {
        if (this.dependvar == null) {
            return;
        }
        Iterator di = this.dependvar.iterator();
        while (di.hasNext()) {
            ((DoublePart)di.next()).removeListener(this);
        }
        double beforevalue = this.value;
        this.value = 0.0;
        this.sendValueChanged(beforevalue, this.value);
    }

    public void valueChanged(DoublePart source, double before, double after) {
        this.addFloat(after - before);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendValueChanged(double before, double after) {
        if (!this.immutable) {
            List list = this.listeners;
            synchronized (list) {
                Iterator iterator = this.listeners.iterator();
                while (iterator.hasNext()) {
                    ((DoublePartListener)iterator.next()).valueChanged(this, before, after);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(DoublePartListener listener) {
        if (!this.immutable) {
            List list = this.listeners;
            synchronized (list) {
                this.listeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(DoublePartListener listener) {
        if (!this.immutable) {
            List list = this.listeners;
            synchronized (list) {
                this.listeners.remove(listener);
            }
        }
    }
}

