/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.math;

import java.util.List;
import rasmus.interpreter.Variable;
import rasmus.interpreter.list.ListPart;
import rasmus.interpreter.list.ListPartListener;
import rasmus.interpreter.math.DoublePart;
import rasmus.interpreter.math.DoublePartListener;
import rasmus.interpreter.sampled.AudioEvents;
import rasmus.interpreter.unit.Parameters;
import rasmus.interpreter.unit.UnitInstancePart;

class CondMulitplierInstance
implements UnitInstancePart,
DoublePartListener {
    Variable answer = null;
    Variable testvar;
    Variable truevar;
    Variable falsevar;
    Variable returnvar;
    ListPartListener listener = new ListPartListener(){

        public void objectAdded(ListPart source, Object object) {
            CondMulitplierInstance.this.calc();
        }

        public void objectRemoved(ListPart source, Object object) {
            CondMulitplierInstance.this.calc();
        }

        public void objectsAdded(ListPart source, List objects) {
            CondMulitplierInstance.this.calc();
        }

        public void objectsRemoved(ListPart source, List objects) {
            CondMulitplierInstance.this.calc();
        }
    };

    public final double toDouble(boolean val) {
        if (val) {
            return 1.0;
        }
        return 0.0;
    }

    public void calc() {
        if (this.returnvar == null) {
            return;
        }
        if (this.answer != null) {
            this.returnvar.remove(this.answer);
        }
        this.answer = null;
        this.answer = DoublePart.asDouble(this.testvar) != 0.0 ? this.truevar : this.falsevar;
        if (this.answer != null) {
            this.returnvar.add(this.answer);
        }
    }

    public CondMulitplierInstance(Parameters parameters) {
        this.returnvar = parameters.getParameter(0, "output");
        this.testvar = parameters.getParameterWithDefault(1, "input");
        this.truevar = parameters.getParameter(2, "true");
        this.falsevar = parameters.getParameter(3, "false");
        DoublePart.getInstance(this.testvar).addListener(this);
        AudioEvents.getInstance(this.testvar).addListener(this.listener);
        this.calc();
    }

    public void close() {
        AudioEvents.getInstance(this.testvar).removeListener(this.listener);
        DoublePart.getInstance(this.testvar).removeListener(this);
        if (this.returnvar == null) {
            return;
        }
        if (this.answer != null) {
            this.returnvar.remove(this.answer);
        }
        this.answer = null;
    }

    public void valueChanged(DoublePart source, double before, double after) {
        this.calc();
    }
}

