/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.list;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import rasmus.interpreter.list.ListPart;
import rasmus.interpreter.list.ListPartListener;

public class SynchronizedList
implements List {
    private List list;
    private ListPartListener listener;
    private ListPart rlist;

    public SynchronizedList(ListPart rlist) {
        this.rlist = rlist;
        this.list = Collections.synchronizedList(new ArrayList());
        this.list.addAll(rlist.getObjects());
        this.listener = new ListPartListener(){

            public void objectAdded(ListPart source, Object object) {
                SynchronizedList.this.list.add(object);
            }

            public void objectRemoved(ListPart source, Object object) {
                SynchronizedList.this.list.remove(object);
            }

            public void objectsAdded(ListPart source, List objects) {
                SynchronizedList.this.list.addAll(objects);
            }

            public void objectsRemoved(ListPart source, List objects) {
                SynchronizedList.this.list.removeAll(objects);
            }
        };
        rlist.addListener(this.listener);
    }

    public void close() {
        if (this.rlist == null) {
            return;
        }
        this.rlist.removeListener(this.listener);
        this.rlist = null;
        this.list.clear();
    }

    public int size() {
        return this.list.size();
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public boolean contains(Object arg0) {
        return this.list.contains(arg0);
    }

    public Iterator iterator() {
        return this.list.iterator();
    }

    public Object[] toArray() {
        return this.list.toArray();
    }

    public Object[] toArray(Object[] arg0) {
        return this.list.toArray(arg0);
    }

    public boolean add(Object arg0) {
        return false;
    }

    public boolean remove(Object arg0) {
        return false;
    }

    public boolean containsAll(Collection arg0) {
        return this.list.containsAll(arg0);
    }

    public boolean addAll(Collection arg0) {
        return false;
    }

    public boolean addAll(int arg0, Collection arg1) {
        return false;
    }

    public boolean removeAll(Collection arg0) {
        return false;
    }

    public boolean retainAll(Collection arg0) {
        return false;
    }

    public void clear() {
        this.close();
    }

    public Object get(int arg0) {
        return this.list.get(arg0);
    }

    public Object set(int arg0, Object arg1) {
        return null;
    }

    public void add(int arg0, Object arg1) {
    }

    public Object remove(int arg0) {
        return null;
    }

    public int indexOf(Object arg0) {
        return this.list.indexOf(arg0);
    }

    public int lastIndexOf(Object arg0) {
        return this.list.lastIndexOf(arg0);
    }

    public ListIterator listIterator() {
        return this.list.listIterator();
    }

    public ListIterator listIterator(int arg0) {
        return this.list.listIterator(arg0);
    }

    public List subList(int arg0, int arg1) {
        return this.list.subList(arg0, arg1);
    }
}

