/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.ext;

import java.util.List;
import rasmus.interpreter.Commitable;
import rasmus.interpreter.NameSpace;
import rasmus.interpreter.Variable;
import rasmus.interpreter.ext.VariableFactory;
import rasmus.interpreter.list.ListPart;
import rasmus.interpreter.list.ListPartListener;
import rasmus.interpreter.list.ObjectsPart;
import rasmus.interpreter.unit.Parameters;
import rasmus.interpreter.unit.Unit;
import rasmus.interpreter.unit.UnitFactory;
import rasmus.interpreter.unit.UnitInstancePart;

class RExternalJavaInstance
implements UnitInstancePart,
Commitable {
    Variable returnvar;
    Variable inputvar;
    Variable answer = null;
    ListPartListener input_listener = new ListPartListener(){

        public void objectAdded(ListPart source, Object object) {
            RExternalJavaInstance.this.calcInput();
        }

        public void objectRemoved(ListPart source, Object object) {
            RExternalJavaInstance.this.calcInput();
        }

        public void objectsAdded(ListPart source, List objects) {
            RExternalJavaInstance.this.calcInput();
        }

        public void objectsRemoved(ListPart source, List objects) {
            RExternalJavaInstance.this.calcInput();
        }
    };
    NameSpace namespace;

    public int getRunLevel() {
        return 0;
    }

    public void calcInput() {
        this.namespace.addToCommitStack(this);
    }

    public void commit() {
        if (this.answer != null) {
            this.returnvar.remove(this.answer);
            this.answer = null;
        }
        try {
            String classname = ObjectsPart.toString(this.inputvar);
            Class<?> varclass = Class.forName(classname);
            Object obj = varclass.newInstance();
            if (obj instanceof VariableFactory) {
                this.answer = ((VariableFactory)obj).asVariable();
            } else if (obj instanceof UnitFactory) {
                this.answer = Unit.asVariable((UnitFactory)obj);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.answer = null;
        }
        if (this.answer != null) {
            this.returnvar.add(this.answer);
        }
    }

    public RExternalJavaInstance(Parameters parameters) {
        this.namespace = parameters.getNameSpace();
        this.returnvar = parameters.getParameterWithDefault(0, "output");
        this.inputvar = parameters.getParameterWithDefault(1, "input");
        ObjectsPart.getInstance(this.inputvar).addListener(this.input_listener);
        this.calcInput();
    }

    public void close() {
        ObjectsPart.getInstance(this.inputvar).removeListener(this.input_listener);
        if (this.answer != null) {
            this.returnvar.remove(this.answer);
            this.answer = null;
        }
        this.returnvar = null;
        this.inputvar = null;
    }
}

