/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.controls.sampled;

import java.awt.Dimension;
import java.util.Arrays;
import java.util.Map;
import rasmus.interpreter.Variable;
import rasmus.interpreter.controls.sampled.AudioAbstractGraphAnalyzer;
import rasmus.interpreter.math.DoublePart;
import rasmus.interpreter.sampled.AudioEvents;
import rasmus.interpreter.sampled.AudioSession;
import rasmus.interpreter.sampled.AudioStream;
import rasmus.interpreter.sampled.util.FFT;

class AudioSpectrumGraphInstance
extends AudioAbstractGraphAnalyzer {
    Variable input;
    Variable timebase;
    Variable samplerate;
    Variable channels;
    Variable fftframesize;
    Variable mindB;
    Variable maxdB;
    Variable minHz;
    Variable maxHz;

    public AudioSpectrumGraphInstance(Map parameters) {
        super(parameters);
        this.timebase = (Variable)parameters.get("timebase");
        this.input = (Variable)parameters.get("input");
        this.samplerate = (Variable)parameters.get("samplerate");
        this.channels = (Variable)parameters.get("channels");
        this.fftframesize = (Variable)parameters.get("fftframesize");
        this.mindB = (Variable)parameters.get("mindb");
        this.maxdB = (Variable)parameters.get("maxdb");
        this.minHz = (Variable)parameters.get("minhz");
        this.maxHz = (Variable)parameters.get("maxhz");
        Dimension size = new Dimension(300, 300);
        this.getJComponent().setPreferredSize(size);
        this.init();
    }

    public void run() {
        if (this.input == null) {
            return;
        }
        super.run();
        double samplerate = 44100.0;
        int channels = 1;
        double timebase = 0.1;
        int fftframesize = 1024;
        double mindB = -180.0;
        double maxdB = 0.0;
        double minHz = 0.0;
        double maxHz = samplerate / 2.0;
        if (this.samplerate != null) {
            samplerate = DoublePart.asDouble(this.samplerate);
        }
        if (this.channels != null) {
            channels = (int)DoublePart.asDouble(this.channels);
        }
        if (this.timebase != null) {
            timebase = DoublePart.asDouble(this.timebase);
        }
        if (this.fftframesize != null) {
            fftframesize = (int)DoublePart.asDouble(this.fftframesize);
        }
        if (this.mindB != null) {
            mindB = (int)DoublePart.asDouble(this.mindB);
        }
        if (this.maxdB != null) {
            maxdB = (int)DoublePart.asDouble(this.maxdB);
        }
        if (this.minHz != null) {
            minHz = (int)DoublePart.asDouble(this.minHz);
        }
        if (this.maxHz != null) {
            maxHz = (int)DoublePart.asDouble(this.maxHz);
        }
        double rangedB = maxdB - mindB;
        fftframesize = (int)Math.pow(2.0, Math.ceil(Math.log(fftframesize) / Math.log(2.0)));
        int fftframesizec = fftframesize * channels;
        int fftframesize2 = fftframesize / 2;
        int binfrom2 = (int)(minHz * (double)fftframesize2 * 2.0 / samplerate);
        int binto2 = (int)(maxHz * (double)fftframesize2 * 2.0 / samplerate);
        if (binfrom2 > fftframesize2) {
            binfrom2 = fftframesize2;
        }
        if (binto2 > fftframesize2) {
            binto2 = fftframesize2;
        }
        if (binfrom2 < 0) {
            binfrom2 = 0;
        }
        if (binto2 < 0) {
            binto2 = 0;
        }
        if (binfrom2 >= binto2) {
            binfrom2 = 0;
            binto2 = fftframesize2;
        }
        int binfrom = binfrom2 * 2;
        int binto = binto2 * 2;
        int binlen2 = binto2 - binfrom2;
        int monitorsamples = (int)(samplerate * timebase);
        int monitorsamplesc = monitorsamples * channels;
        AudioSession audiosession = new AudioSession(samplerate, channels);
        AudioStream audiostream = AudioEvents.openStream(this.input, audiosession);
        FFT fft = new FFT(fftframesize);
        double[][] fftbuffer = new double[channels][];
        double[][] graphbuffer = new double[channels][];
        int c = 0;
        while (c < channels) {
            fftbuffer[c] = new double[fftframesize];
            graphbuffer[c] = new double[binlen2];
            ++c;
        }
        double[] window = fft.wHanning();
        int bufferlen = monitorsamplesc;
        if (bufferlen < fftframesizec) {
            bufferlen = fftframesizec;
        }
        double[] buffer = new double[bufferlen];
        while (this.isActive()) {
            double[] fftbuff;
            int i = 0;
            while (i < bufferlen - monitorsamplesc) {
                buffer[i] = buffer[i + monitorsamplesc];
                ++i;
            }
            int len = audiostream.replace(buffer, bufferlen - monitorsamplesc, bufferlen);
            if (len == -1) break;
            Arrays.fill(buffer, bufferlen - monitorsamplesc + len, bufferlen, 0.0);
            int c2 = 0;
            while (c2 < channels) {
                fftbuff = fftbuffer[c2];
                int ci = c2;
                int i2 = 0;
                while (i2 < fftframesize) {
                    fftbuff[i2] = buffer[ci] * window[i2];
                    ci += channels;
                    ++i2;
                }
                fft.calcReal(fftbuff, -1);
                ++c2;
            }
            c2 = 0;
            while (c2 < channels) {
                fftbuff = fftbuffer[c2];
                double[] gbuffer = graphbuffer[c2];
                int x = 0;
                int i3 = binfrom;
                while (i3 < binto) {
                    double logman;
                    double real = fftbuff[i3++];
                    double imag = fftbuff[i3++];
                    double magn = 4.0 * Math.sqrt(real * real + imag * imag) / (double)fftframesize;
                    gbuffer[x] = logman = (Math.log10(magn) * 20.0 - mindB) / rangedB;
                    ++x;
                }
                ++c2;
            }
            this.paint(graphbuffer);
        }
        audiostream.close();
        audiosession.close();
    }
}

