/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.controls.sampled;

import java.awt.Color;
import java.awt.Dimension;
import java.util.Arrays;
import java.util.Map;
import rasmus.interpreter.Variable;
import rasmus.interpreter.controls.sampled.AudioAbstractAnalyzer;
import rasmus.interpreter.math.DoublePart;
import rasmus.interpreter.sampled.AudioEvents;
import rasmus.interpreter.sampled.AudioSession;

class AudioOscilloscopeXYInstance
extends AudioAbstractAnalyzer {
    Variable input;
    Variable timebase;
    Variable samplerate;
    Variable refreshrate;

    public AudioOscilloscopeXYInstance(Map parameters) {
        super(parameters);
        this.timebase = (Variable)parameters.get("timebase");
        this.input = (Variable)parameters.get("input");
        this.samplerate = (Variable)parameters.get("samplerate");
        this.refreshrate = (Variable)parameters.get("refreshrate");
        Dimension size = new Dimension(300, 300);
        this.getJComponent().setPreferredSize(size);
        this.init();
    }

    /*
     * Unable to fully structure code
     */
    public void run() {
        if (this.input == null) {
            return;
        }
        samplerate = 44100.0;
        refreshrate = 15.0;
        channels = 2;
        timebase = 0.01;
        if (this.samplerate != null) {
            samplerate = DoublePart.asDouble(this.samplerate);
        }
        if (this.timebase != null) {
            timebase = (int)DoublePart.asDouble(this.timebase);
        }
        if (this.refreshrate != null) {
            refreshrate = (int)DoublePart.asDouble(this.refreshrate);
        }
        monitorsamples = (int)(samplerate * timebase);
        monitorsamplesc = monitorsamples * channels;
        audiosession = new AudioSession(samplerate, channels);
        audiostream = AudioEvents.openStream(this.input, audiosession);
        bufferlen = monitorsamplesc;
        if (bufferlen < 500) {
            bufferlen = 500 - 500 % channels;
        }
        buffer = new double[bufferlen];
        waittimens = (int)(1000.0 / refreshrate);
        lastms = System.currentTimeMillis();
        ** GOTO lbl53
        while ((len = audiostream.replace(buffer, 0, bufferlen)) != -1) {
            if (len != bufferlen) {
                Arrays.fill(buffer, len, bufferlen, 0.0);
            }
            while (System.currentTimeMillis() - lastms >= waittimens) {
                lastms = System.currentTimeMillis();
                g = this.getGraphics();
                size = this.getSize();
                w = size.width;
                h = size.height;
                g.setColor(Color.BLACK);
                g.fillRect(0, 0, w, h);
                g.setColor(Color.GRAY);
                g.drawLine(0, h / 2, w, h / 2);
                g.drawLine(w / 2, 0, w / 2, h);
                lastx = (int)((buffer[0] * 0.5 + 0.5) * (double)w);
                lasty = (int)((buffer[1] * 0.5 + 0.5) * (double)h);
                g.setColor(Color.CYAN);
                i = 0;
                while (i < monitorsamplesc) {
                    sampleX = buffer[i];
                    sampleY = buffer[i + 1];
                    x = (int)((sampleX * 0.5 + 0.5) * (double)w);
                    y = (int)((sampleY * 0.5 + 0.5) * (double)h);
                    g.drawLine(lastx, lasty, x, y);
                    lasty = y;
                    lastx = x;
                    i += 2;
                }
                this.repaint();
lbl53:
                // 2 sources

                if (this.isActive()) continue;
            }
        }
        audiostream.close();
    }
}

