/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.controls.sampled;

import java.awt.Dimension;
import java.util.Arrays;
import java.util.Map;
import rasmus.interpreter.NameSpace;
import rasmus.interpreter.Variable;
import rasmus.interpreter.controls.sampled.AudioAbstractGraphAnalyzer;
import rasmus.interpreter.math.DoublePart;
import rasmus.interpreter.sampled.AudioEvents;
import rasmus.interpreter.sampled.AudioSession;
import rasmus.interpreter.sampled.AudioStream;
import rasmus.interpreter.sampled.util.FFT;

class AudioCepstrumGraphInstance
extends AudioAbstractGraphAnalyzer {
    Variable input;
    Variable timebase;
    Variable samplerate;
    Variable channels;
    Variable fftframesize;
    Variable mindB;
    Variable maxdB;
    Variable minHz;
    Variable maxHz;

    public AudioCepstrumGraphInstance(NameSpace namespace, Map parameters) {
        super(parameters);
        this.timebase = (Variable)parameters.get("timebase");
        this.input = (Variable)parameters.get("input");
        this.samplerate = (Variable)parameters.get("samplerate");
        this.channels = (Variable)parameters.get("channels");
        this.fftframesize = (Variable)parameters.get("fftframesize");
        Dimension size = new Dimension(300, 300);
        this.getJComponent().setPreferredSize(size);
        this.init();
    }

    public void run() {
        if (this.input == null) {
            return;
        }
        super.run();
        double samplerate = 44100.0;
        int channels = 1;
        double timebase = 0.1;
        int fftframesize = 1024;
        if (this.samplerate != null) {
            samplerate = DoublePart.asDouble(this.samplerate);
        }
        if (this.channels != null) {
            channels = (int)DoublePart.asDouble(this.channels);
        }
        if (this.timebase != null) {
            timebase = DoublePart.asDouble(this.timebase);
        }
        if (this.fftframesize != null) {
            fftframesize = (int)DoublePart.asDouble(this.fftframesize);
        }
        fftframesize = (int)Math.pow(2.0, Math.ceil(Math.log(fftframesize) / Math.log(2.0)));
        int fftframesizec = fftframesize * channels;
        int fftframesize2 = fftframesize / 2;
        int fftframesize4 = fftframesize / 4;
        int monitorsamples = (int)(samplerate * timebase);
        int monitorsamplesc = monitorsamples * channels;
        AudioSession audiosession = new AudioSession(samplerate, channels);
        AudioStream audiostream = AudioEvents.openStream(this.input, audiosession);
        FFT fft = new FFT(fftframesize);
        FFT fft2 = new FFT(fftframesize / 2);
        double[][] fftbuffer = new double[channels][];
        double[][] fftbuffer2 = new double[channels][];
        double[][] graphbuffer = new double[channels][];
        int c = 0;
        while (c < channels) {
            fftbuffer[c] = new double[fftframesize];
            fftbuffer2[c] = new double[fftframesize2];
            graphbuffer[c] = new double[fftframesize4];
            ++c;
        }
        double[] window = fft.wHanning();
        int bufferlen = monitorsamplesc;
        if (bufferlen < fftframesizec) {
            bufferlen = fftframesizec;
        }
        double[] buffer = new double[bufferlen];
        while (this.isActive()) {
            int i;
            int i2 = 0;
            while (i2 < bufferlen - monitorsamplesc) {
                buffer[i2] = buffer[i2 + monitorsamplesc];
                ++i2;
            }
            int len = audiostream.replace(buffer, bufferlen - monitorsamplesc, bufferlen);
            if (len == -1) break;
            Arrays.fill(buffer, bufferlen - monitorsamplesc + len, bufferlen, 0.0);
            int c2 = 0;
            while (c2 < channels) {
                double[] fftbuff = fftbuffer[c2];
                int ci = c2;
                int i3 = 0;
                while (i3 < fftframesize) {
                    fftbuff[i3] = buffer[ci] * window[i3];
                    ci += channels;
                    ++i3;
                }
                fft.calcReal(fftbuff, -1);
                double[] fftbuff2 = fftbuffer2[c2];
                i = 0;
                int j = 0;
                while (j < fftframesize2) {
                    double real = fftbuff[i++];
                    double imag = fftbuff[i++];
                    fftbuff2[j] = Math.log(Math.sqrt(real * real + imag * imag));
                    ++j;
                }
                fft2.calcReal(fftbuff2, -1);
                ++c2;
            }
            c2 = 0;
            while (c2 < channels) {
                double[] fftbuff2 = fftbuffer2[c2];
                double[] gbuffer = graphbuffer[c2];
                int x = 0;
                i = 0;
                while (i < fftframesize2) {
                    double real = fftbuff2[i++];
                    double imag = fftbuff2[i++];
                    double magn = Math.sqrt(real * real + imag * imag) / (double)fftframesize2;
                    gbuffer[x] = 1.0 + Math.log10(magn) / 2.0;
                    ++x;
                }
                ++c2;
            }
            this.paint(graphbuffer);
        }
        audiostream.close();
        audiosession.close();
    }
}

