/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter.controls.sampled;

import java.util.Map;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.Receiver;
import rasmus.interpreter.Variable;
import rasmus.interpreter.controls.ControlPaintAdapter;
import rasmus.interpreter.math.DoublePart;
import rasmus.interpreter.midi.MidiSequence;

public abstract class AudioAbstractAnalyzer
extends ControlPaintAdapter
implements Receiver,
Runnable {
    Variable control = null;
    Variable autostart = null;
    Thread analyzerthread = null;
    boolean active = false;

    public AudioAbstractAnalyzer(Map parameters) {
        this.control = (Variable)parameters.get("control");
        this.autostart = (Variable)parameters.get("autostart");
        if (this.control != null) {
            MidiSequence.getInstance(this.control).addReceiver(this);
        }
    }

    public void init() {
        if (this.control != null) {
            if (this.autostart != null && (int)DoublePart.asDouble(this.autostart) == 1) {
                this.start();
            }
        } else {
            this.start();
        }
    }

    public void close() {
        this.stop();
        if (this.control != null) {
            MidiSequence.getInstance(this.control).removeReceiver(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isActive() {
        AudioAbstractAnalyzer audioAbstractAnalyzer = this;
        synchronized (audioAbstractAnalyzer) {
            return this.active;
        }
    }

    public void start() {
        if (this.analyzerthread != null) {
            return;
        }
        this.analyzerthread = new Thread(new Runnable(){

            public void run() {
                AudioAbstractAnalyzer.this.run();
                AudioAbstractAnalyzer.this.active = false;
                AudioAbstractAnalyzer.this.analyzerthread = null;
            }
        });
        this.active = true;
        this.analyzerthread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        AudioAbstractAnalyzer audioAbstractAnalyzer = this;
        synchronized (audioAbstractAnalyzer) {
            this.active = false;
        }
    }

    public void send(MidiMessage arg0, long arg1) {
        int status = arg0.getStatus();
        if (status == 250 || status == 251) {
            this.start();
        }
        if (status == 252) {
            this.stop();
        }
    }

    public void calc() {
    }
}

