/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter;

import java.util.ArrayList;
import java.util.Iterator;
import rasmus.interpreter.VariablePart;

public final class Variable {
    private VariablePart[] partarray = null;
    private ArrayList<Variable> variables = null;
    private Variable singlevar = null;

    public Variable() {
    }

    public Variable(VariablePart variablepart) {
        this.partarray = new VariablePart[1];
        this.partarray[0] = variablepart;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void add(Variable variable) {
        Variable variable2 = this;
        synchronized (variable2) {
            if (this.variables == null && this.singlevar == null) {
                this.singlevar = variable;
            } else {
                if (this.variables == null) {
                    this.variables = new ArrayList();
                    this.variables.add(this.singlevar);
                }
                this.variables.add(variable);
                this.singlevar = null;
            }
            if (this.partarray != null) {
                int i = 0;
                while (i < this.partarray.length) {
                    VariablePart variablepart = this.partarray[i];
                    variablepart.add(variable);
                    ++i;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void remove(Variable variable) {
        Variable variable2 = this;
        synchronized (variable2) {
            if (this.variables != null) {
                this.variables.remove(variable);
                if (this.variables.size() == 0) {
                    this.variables = null;
                }
            } else if (this.singlevar != null && this.singlevar == variable) {
                this.singlevar = null;
            }
            if (this.partarray != null) {
                int i = 0;
                while (i < this.partarray.length) {
                    VariablePart variablepart = this.partarray[i];
                    variablepart.remove(variable);
                    ++i;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clear() {
        Variable variable = this;
        synchronized (variable) {
            if (this.partarray != null) {
                int i = 0;
                while (i < this.partarray.length) {
                    VariablePart variablepart = this.partarray[i];
                    variablepart.clear();
                    ++i;
                }
            }
            this.partarray = null;
            this.variables = null;
            this.singlevar = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean has(Class classobject) {
        Variable variable = this;
        synchronized (variable) {
            try {
                if (this.partarray != null) {
                    int i = 0;
                    while (i < this.partarray.length) {
                        if (this.partarray[i].getClass() == classobject) {
                            return true;
                        }
                        ++i;
                    }
                }
                if (this.singlevar != null && this.singlevar.has(classobject)) {
                    return true;
                }
                if (this.variables != null) {
                    for (Variable vvar : this.variables) {
                        if (!vvar.has(classobject)) continue;
                        return true;
                    }
                }
            }
            finally {
                Throwable throwable;
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final VariablePart get(Class classobject) {
        Variable variable = this;
        synchronized (variable) {
            VariablePart[] new_partarray;
            VariablePart o;
            if (this.partarray != null) {
                int i = 0;
                while (i < this.partarray.length) {
                    if (this.partarray[i].getClass() == classobject) {
                        return this.partarray[i];
                    }
                    ++i;
                }
            }
            try {
                o = (VariablePart)classobject.newInstance();
                o.init(this);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
            if (this.variables != null) {
                Iterator<Variable> iterator = this.variables.iterator();
                while (iterator.hasNext()) {
                    o.add(iterator.next());
                }
            } else if (this.singlevar != null) {
                o.add(this.singlevar);
            }
            if (this.partarray == null) {
                new_partarray = new VariablePart[1];
            } else {
                new_partarray = new VariablePart[this.partarray.length + 1];
                int i = 0;
                while (i < this.partarray.length) {
                    new_partarray[i] = this.partarray[i];
                    ++i;
                }
            }
            new_partarray[new_partarray.length - 1] = o;
            this.partarray = new_partarray;
            return o;
        }
    }
}

