/*
 * Decompiled with CFR 0.152.
 */
package rasmus.interpreter;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import rasmus.interpreter.Closeable;
import rasmus.interpreter.Commitable;
import rasmus.interpreter.Executable;
import rasmus.interpreter.ExecutableInstance;
import rasmus.interpreter.NameSpace;
import rasmus.interpreter.NameSpaceAdapter;
import rasmus.interpreter.Variable;
import rasmus.interpreter.list.ObjectsPart;
import rasmus.interpreter.math.DoublePart;
import rasmus.interpreter.namespace.GlobalNameSpace;
import rasmus.interpreter.namespace.InheritNameSpace;
import rasmus.interpreter.parser.ScriptCompiler;
import rasmus.interpreter.parser.ScriptParserException;
import rasmus.interpreter.unit.Parameters;
import rasmus.interpreter.unit.Unit;
import rasmus.interpreter.unit.UnitFactory;

public class Interpreter
extends NameSpaceAdapter
implements Closeable {
    private ArrayList<Closeable> instances = new ArrayList();
    private boolean autocommit = true;

    public Interpreter() {
        super(new InheritNameSpace(GlobalNameSpace.getNameSpace()));
    }

    public Interpreter(NameSpace namespace) {
        super(namespace);
    }

    public void setNameSpace(NameSpace namespace) {
        super.setNameSpace(namespace);
    }

    public boolean getAutoCommit() {
        return this.autocommit;
    }

    public void setAutoCommit(boolean value) {
        this.autocommit = value;
    }

    public Variable source(String filename) throws IOException, ScriptParserException {
        return this.source(new File(filename));
    }

    public Variable source(File file) throws IOException, ScriptParserException {
        Variable ret;
        FileInputStream istream = new FileInputStream(file);
        BufferedInputStream bistream = new BufferedInputStream(istream);
        try {
            ret = this.source(bistream);
        }
        finally {
            istream.close();
        }
        return ret;
    }

    public Variable source(InputStream instream) throws IOException, ScriptParserException {
        StringBuffer sb = new StringBuffer();
        InputStreamReader reader = new InputStreamReader(instream);
        BufferedReader breader = new BufferedReader(reader);
        String line = breader.readLine();
        while (line != null) {
            sb.append(String.valueOf(line) + "\r\n");
            line = breader.readLine();
        }
        reader.close();
        return this.eval(sb.toString());
    }

    public Variable execute(Executable executable) {
        ExecutableInstance instance = executable.execute(this.getNameSpace());
        this.instances.add(instance);
        if (this.autocommit) {
            this.commit();
        }
        return instance.getReturnVariable();
    }

    public Variable eval(String script) throws ScriptParserException {
        return this.execute(ScriptCompiler.compile(script));
    }

    public void close() {
        this.addToCommitStack(new Commitable(){

            public int getRunLevel() {
                return 0;
            }

            public void commit() {
                Iterator iter = Interpreter.this.instances.iterator();
                while (iter.hasNext()) {
                    ((Closeable)iter.next()).close();
                }
                Interpreter.this.instances.clear();
            }
        });
        if (this.autocommit) {
            this.commit();
        }
    }

    public void add(Variable var, Variable data) {
        this.addToCommitStack(new AddInstance(var, data));
        if (this.autocommit) {
            this.commit();
        }
    }

    public void add(String varname, Variable data) {
        this.add(this.get(varname), data);
    }

    public void add(String varname, Object object) {
        this.add(varname, this.asVariable(object));
    }

    public void add(Variable var, Object object) {
        this.add(var, this.asVariable(object));
    }

    public Variable asVariable(Object value) {
        if (value == null) {
            return new Variable();
        }
        if (value instanceof Variable) {
            return (Variable)value;
        }
        if (value instanceof Number) {
            return DoublePart.asVariable(((Number)value).doubleValue());
        }
        if (value instanceof String) {
            return ObjectsPart.asVariable(value);
        }
        if (value instanceof File) {
            Variable output = new Variable();
            this.call("file", output, this.asVariable(((File)value).getPath()));
            return output;
        }
        return new Variable();
    }

    public void call(String unit, Object ... arguments) {
        this.callUnit(this.get(unit), arguments);
    }

    public void call(UnitFactory unit, Object ... arguments) {
        this.callUnit(Unit.asVariable(unit), arguments);
    }

    public void call(Variable unit, Object ... arguments) {
        this.callUnit(unit, arguments);
    }

    private void callUnit(Variable unit, Object[] arguments) {
        this.addToCommitStack(new CallTask(unit, arguments));
        if (this.autocommit) {
            this.commit();
        }
    }

    private class AddInstance
    implements Closeable,
    Commitable {
        private Variable var;
        private Variable data;

        public int getRunLevel() {
            return 0;
        }

        public AddInstance(Variable var, Variable data) {
            this.var = var;
            this.data = data;
        }

        public void close() {
            if (this.var == null) {
                return;
            }
            this.var.remove(this.data);
            this.var = null;
            this.data = null;
        }

        public void commit() {
            this.var.add(this.data);
            Interpreter.this.instances.add(this);
        }
    }

    private class CallTask
    implements Commitable {
        Variable unit;
        Object[] arguments;

        public CallTask(Variable unit, Object[] arguments) {
            this.unit = unit;
            this.arguments = arguments;
        }

        public int getRunLevel() {
            return 0;
        }

        public void commit() {
            int ix = 0;
            Parameters uparams = new Parameters(Interpreter.this);
            int i = 0;
            while (i < this.arguments.length) {
                Object arg = this.arguments[i];
                if (arg instanceof Map) {
                    Map map = (Map)arg;
                    for (Map.Entry entry : map.entrySet()) {
                        uparams.setParameter((String)entry.getKey(), Interpreter.this.asVariable(entry.getValue()));
                    }
                } else {
                    uparams.setParameter(ix, Interpreter.this.asVariable(arg));
                    ++ix;
                }
                ++i;
            }
            Interpreter.this.instances.add(Unit.newInstance(this.unit, uparams));
        }
    }
}

