/*
 * Decompiled with CFR 0.152.
 */
package rasmus.fft.spi;

import rasmus.fft.FFTTransformer;

public abstract class FFTProvider {
    public abstract Info getInfo();

    public FFTTransformer getTransformer(int fftsize, int direction, boolean inplace) {
        return null;
    }

    public FFTTransformer getTransformer(int[] dims, int direction, boolean inplace) {
        if (dims.length == 1) {
            return this.getTransformer(dims[0], direction, inplace);
        }
        return null;
    }

    public class Info {
        public static final int PRIORITY_NATIVE = 40;
        public static final int PRIORITY_OPTIMIZED = 30;
        public static final int PRIORITY_FFT = 20;
        public static final int PRIORITY_DFT = 10;
        public static final int PRIORITY_OPTIONAL = 0;
        private String name;
        private String vendor;
        private String description;
        private String version;
        private int priority;

        public Info(String name, String vendor, String description, String version, int priority) {
            this.name = name;
            this.vendor = vendor;
            this.description = description;
            this.version = version;
            this.priority = priority;
        }

        public String getName() {
            return this.name;
        }

        public String getVendor() {
            return this.vendor;
        }

        public String getDescription() {
            return this.description;
        }

        public String getVersion() {
            return this.version;
        }

        public int getPriority() {
            return this.priority;
        }
    }
}

