/*
 * Decompiled with CFR 0.152.
 */
package rasmus.fft.radix2;

public class BitReversal {
    public int[] bitm_array;
    public int[] bitm_array2;
    public int fftFrameSize;
    public int fftFrameSize2;

    public BitReversal(int fftFrameSize) {
        this.fftFrameSize = fftFrameSize;
        this.fftFrameSize2 = fftFrameSize << 1;
        this.bitm_array = new int[this.fftFrameSize2];
        int i = 2;
        while (i < this.fftFrameSize2) {
            int bitm = 2;
            int j = 0;
            while (bitm < this.fftFrameSize2) {
                if ((i & bitm) != 0) {
                    ++j;
                }
                j <<= 1;
                bitm <<= 1;
            }
            this.bitm_array[i] = j;
            i += 2;
        }
        int bcount = 0;
        int size = this.fftFrameSize2 - 2;
        int i2 = 2;
        while (i2 < size) {
            int j = this.bitm_array[i2];
            if (i2 < j) {
                ++bcount;
            }
            i2 += 2;
        }
        this.bitm_array2 = new int[bcount * 2];
        int k = 0;
        int i3 = 2;
        while (i3 < size) {
            int j = this.bitm_array[i3];
            if (i3 < j) {
                this.bitm_array2[k++] = i3;
                this.bitm_array2[k++] = j;
            }
            i3 += 2;
        }
    }

    public final void transform(double[] data) {
        if (this.fftFrameSize < 4) {
            return;
        }
        int inverse = this.fftFrameSize2 - 2;
        int i = 0;
        while (i < this.fftFrameSize) {
            double tempi;
            double tempr;
            int j = this.bitm_array[i];
            if (i < j) {
                int n = i;
                int m = j;
                tempr = data[n];
                data[n] = data[m];
                data[m] = tempr;
                tempi = data[++n];
                data[n] = data[++m];
                data[m] = tempi;
                n = inverse - i;
                m = inverse - j;
                tempr = data[n];
                data[n] = data[m];
                data[m] = tempr;
                tempi = data[++n];
                data[n] = data[++m];
                data[m] = tempi;
            }
            int m = j + this.fftFrameSize;
            int n = i + 2;
            tempr = data[n];
            data[n] = data[m];
            data[m] = tempr;
            tempi = data[++n];
            data[n] = data[++m];
            data[m] = tempi;
            i += 4;
        }
    }

    public final void transform1(double[] data) {
        int size = this.bitm_array2.length;
        int i = 0;
        while (i < size) {
            int n = this.bitm_array2[i++];
            int m = this.bitm_array2[i];
            double tempr = data[n];
            data[n] = data[m];
            data[m] = tempr;
            double tempi = data[++n];
            data[n] = data[++m];
            data[m] = tempi;
            ++i;
        }
    }

    public final void transform2(double[] data) {
        int[] bitm_array = this.bitm_array;
        int size = this.fftFrameSize2 - 2;
        int i = 2;
        while (i < size) {
            int j = bitm_array[i];
            if (i < j) {
                int n = i;
                int m = j;
                double tempr = data[n];
                data[n] = data[m];
                data[m] = tempr;
                double tempi = data[++n];
                data[n] = data[++m];
                data[m] = tempi;
            }
            i += 2;
        }
    }
}

