/*
 * Decompiled with CFR 0.152.
 */
package rasmus.fft.providers;

import rasmus.fft.FFT;
import rasmus.fft.FFTTransformer;

class ComplexToReal2Transformer
implements FFTTransformer {
    FFTTransformer fft;
    int fftFrameSize;
    int fftFrameSize2;
    double[] buffer;
    double[] buffer2;

    public ComplexToReal2Transformer(int fftFrameSize, boolean inplace) {
        this.fft = FFT.getTransformer(fftFrameSize, 1, inplace);
        this.fftFrameSize = fftFrameSize;
        this.fftFrameSize2 = fftFrameSize << 1;
        this.buffer = new double[this.fftFrameSize2];
        this.buffer2 = new double[this.fftFrameSize2];
    }

    public void transform(double[] data) {
        int i = 0;
        while (i < this.fftFrameSize) {
            this.buffer[i] = data[i];
            this.buffer[i + 1] = data[i + 1];
            this.buffer[this.fftFrameSize2 - 2 - i] = 0.0;
            this.buffer[this.fftFrameSize2 - 2 - i + 1] = 0.0;
            i += 2;
        }
        this.fft.transform(this.buffer);
        i = 0;
        while (i < this.fftFrameSize) {
            data[i] = this.buffer[i << 1];
            ++i;
        }
    }

    public void transform(double[] data, double[] out) {
        int i = 0;
        while (i < this.fftFrameSize) {
            this.buffer[i] = data[i];
            this.buffer[i + 1] = data[i + 1];
            this.buffer[this.fftFrameSize2 - 2 - i] = 0.0;
            this.buffer[this.fftFrameSize2 - 2 - i + 1] = 0.0;
            i += 2;
        }
        this.fft.transform(this.buffer, this.buffer2);
        i = 0;
        while (i < data.length) {
            data[i] = this.buffer2[i << 1];
            ++i;
        }
    }
}

