/*
 * Decompiled with CFR 0.152.
 */
package rasmus.fft.providers;

import java.util.Arrays;
import rasmus.fft.FFTTransformer;

class ComplexToComplex2Transformer
implements FFTTransformer {
    private double[] ptable = null;
    private double[] aa = null;
    private int fftFrameSize;

    public ComplexToComplex2Transformer(int fftFrameSize, int direction) {
        this.fftFrameSize = fftFrameSize;
        int partials = fftFrameSize / 2;
        int p = 0;
        this.ptable = new double[2 * fftFrameSize * partials];
        int hfs = fftFrameSize / 2;
        double pd = Math.PI / (double)hfs;
        int i = 0;
        while (i < fftFrameSize) {
            int im = i - hfs;
            int h = 0;
            while (h < partials) {
                double th = pd * (double)(h + 1) * (double)im;
                this.ptable[p++] = Math.cos(th);
                this.ptable[p++] = Math.sin(th) * (double)direction;
                ++h;
            }
            ++i;
        }
    }

    public void transform(double[] data) {
        if (this.aa == null) {
            this.aa = new double[this.fftFrameSize * 2];
        }
        this.transform(data, this.aa);
        int h = 0;
        while (h < this.fftFrameSize) {
            data[h] = this.aa[h];
            ++h;
        }
    }

    public void transform(double[] in, double[] out) {
        Arrays.fill(out, 0.0);
        int i = 0;
        int p = 0;
        while (i < this.fftFrameSize) {
            double w = in[i * 2];
            int h = 0;
            while (h < this.fftFrameSize) {
                int n = h++;
                out[n] = out[n] + w * this.ptable[p++];
            }
            ++i;
        }
    }
}

