/*
 * Decompiled with CFR 0.152.
 */
package rasmus.fft.providers;

import rasmus.fft.FFTTransformer;

class ComplexSimpleRadix2Transformer
implements FFTTransformer {
    int[] bitm_array;
    int direction;
    int fftFrameSize;

    public ComplexSimpleRadix2Transformer(int fftFrameSize, int direction) {
        this.direction = direction;
        this.fftFrameSize = fftFrameSize;
    }

    public void transform(double[] data) {
        int sign = this.direction;
        int fftFrameSize2 = this.fftFrameSize << 1;
        int i = 2;
        while (i < fftFrameSize2 - 2) {
            int bitm = 2;
            int j = 0;
            while (bitm < fftFrameSize2) {
                if ((i & bitm) != 0) {
                    ++j;
                }
                j <<= 1;
                bitm <<= 1;
            }
            if (i < j) {
                int n = i;
                int m = j;
                double tempr = data[n];
                data[n] = data[m];
                data[m] = tempr;
                double tempi = data[++n];
                data[n] = data[++m];
                data[m] = tempi;
            }
            i += 2;
        }
        int imax = (int)(Math.log(this.fftFrameSize) / Math.log(2.0));
        int i2 = 0;
        int nstep = 2;
        while (i2 < imax) {
            int jmax = nstep;
            nstep <<= 1;
            double wr = 1.0;
            double wi = 0.0;
            double arg = Math.PI / (double)(jmax >> 1);
            double wfr = Math.cos(arg);
            double wfi = (double)sign * Math.sin(arg);
            int j = 0;
            while (j < jmax) {
                int n = j;
                while (n < fftFrameSize2) {
                    int m = n + jmax;
                    double tempr = data[m] * wr - data[m + 1] * wi;
                    double tempi = data[m] * wi + data[m + 1] * wr;
                    data[m] = data[n] - tempr;
                    data[m + 1] = data[n + 1] - tempi;
                    int n2 = n;
                    data[n2] = data[n2] + tempr;
                    int n3 = n + 1;
                    data[n3] = data[n3] + tempi;
                    n += nstep;
                }
                double tempr = wr;
                wr = tempr * wfr - wi * wfi;
                wi = tempr * wfi + wi * wfr;
                j += 2;
            }
            ++i2;
        }
    }

    public void transform(double[] in, double[] out) {
        System.arraycopy(in, 0, out, 0, in.length);
        this.transform(out);
    }
}

