/*
 * Decompiled with CFR 0.152.
 */
package rasmus.fft.providers;

import rasmus.fft.FFTTransformer;
import rasmus.fft.radix2.BitReversal;
import rasmus.fft.radix2.OpFFT;

class ComplexSimple3Radix2Transformer
implements FFTTransformer {
    double[] fft_cos;
    double[] fft_sin;
    int[] bitm_array;
    int direction;
    int fftFrameSize;
    int fftFrameSize2;
    int imax;
    double[] w;
    BitReversal bitrev;

    public ComplexSimple3Radix2Transformer(int fftFrameSize, int direction) {
        this.w = OpFFT.computeTwiddleFactors(fftFrameSize, direction);
        this.bitrev = new BitReversal(fftFrameSize);
        this.imax = (int)(Math.log(fftFrameSize) / Math.log(2.0));
        this.fft_cos = new double[this.imax];
        this.fft_sin = new double[this.imax];
        int k = 0;
        int le = 2;
        while (k < this.imax) {
            int le2 = (le <<= 1) >> 1;
            double arg = Math.PI / (double)(le2 >> 1);
            this.fft_cos[k] = Math.cos(arg);
            this.fft_sin[k] = Math.sin(arg);
            ++k;
        }
        this.fftFrameSize2 = fftFrameSize << 1;
        this.direction = direction;
        this.fftFrameSize = fftFrameSize;
    }

    public void transform(double[] data) {
        int[] bitm_array2 = this.bitrev.bitm_array2;
        int size = bitm_array2.length;
        int i = 0;
        while (i < size) {
            int n = bitm_array2[i++];
            int m = bitm_array2[i];
            double tempr = data[n];
            data[n] = data[m];
            data[m] = tempr;
            double tempi = data[++n];
            data[n] = data[++m];
            data[m] = tempi;
            ++i;
        }
        int fftFrameSize2 = 2 * this.fftFrameSize;
        double[] w = this.w;
        int i2 = 0;
        int nstep = 2;
        while (nstep < fftFrameSize2) {
            int jmax = nstep;
            nstep <<= 1;
            int j = 0;
            while (j < jmax) {
                double wr = w[i2++];
                double wi = w[i2++];
                int n = j;
                while (n < fftFrameSize2) {
                    int m = n + jmax;
                    double datam_r = data[m];
                    double datam_i = data[m + 1];
                    double datan_r = data[n];
                    double datan_i = data[n + 1];
                    double tempr = datam_r * wr - datam_i * wi;
                    double tempi = datam_r * wi + datam_i * wr;
                    data[m] = datan_r - tempr;
                    data[m + 1] = datan_i - tempi;
                    data[n] = datan_r + tempr;
                    data[n + 1] = datan_i + tempi;
                    n += nstep;
                }
                j += 2;
            }
        }
    }

    public void transform(double[] in, double[] out) {
        System.arraycopy(in, 0, out, 0, in.length);
        this.transform(out);
    }
}

