/*
 * Decompiled with CFR 0.152.
 */
package rasmus.fft.providers;

import rasmus.fft.FFTTransformer;
import rasmus.fft.radix2.BitReversal;
import rasmus.fft.radix2.OpFFT;

class ComplexRadix2Transformer
implements FFTTransformer {
    double[] w;
    BitReversal bitrev;
    int direction;
    int fftFrameSize;

    public ComplexRadix2Transformer(int fftFrameSize, int direction) {
        this.w = OpFFT.computeTwiddleFactors(fftFrameSize, direction);
        this.bitrev = new BitReversal(fftFrameSize);
        this.direction = direction;
        this.fftFrameSize = fftFrameSize;
    }

    public void transform(double[] data) {
        this.bitrev.transform(data);
        OpFFT.calc(this.fftFrameSize, data, this.direction, this.w);
    }

    public void transform(double[] in, double[] out) {
        System.arraycopy(in, 0, out, 0, in.length);
        this.transform(out);
    }
}

