/*
 * Decompiled with CFR 0.152.
 */
package rasmus.fft.kissfft;

class KissFft {
    private int nfft;
    private boolean inverse;
    private int[] factors = new int[32];
    private double[] twiddles_r;
    private double[] twiddles_i;
    private double[] scratchbuf_i = null;
    private double[] scratchbuf_r = null;
    private double[] tmpbuf = null;

    public KissFft(int nfft, boolean inverse_fft) {
        this.twiddles_r = new double[nfft];
        this.twiddles_i = new double[nfft];
        this.nfft = nfft;
        this.inverse = inverse_fft;
        int i = 0;
        while (i < nfft) {
            double pi = Math.PI;
            double phase = -2.0 * pi * (double)i / (double)nfft;
            if (this.inverse) {
                phase *= -1.0;
            }
            this.twiddles_r[i] = Math.cos(phase);
            this.twiddles_i[i] = Math.sin(phase);
            ++i;
        }
        this.factor(nfft, this.factors);
        int p = 1;
        int j = 0;
        while (j < this.factors.length) {
            if (this.factors[j] > p) {
                p = this.factors[j];
            }
            j += 2;
        }
        if (p > 5) {
            this.scratchbuf_r = new double[p];
            this.scratchbuf_i = new double[p];
        }
    }

    private void bfly2(double[] Fout, int Fout_index, int fstride, int m) {
        int tw1 = 0;
        int Fout2 = Fout_index + m;
        do {
            double Fout2_r = Fout[Fout2 << 1];
            double Fout2_i = Fout[(Fout2 << 1) + 1];
            double Fout_r = Fout[Fout_index << 1];
            double Fout_i = Fout[(Fout_index << 1) + 1];
            double t_r = Fout2_r * this.twiddles_r[tw1] - Fout2_i * this.twiddles_i[tw1];
            double t_i = Fout2_r * this.twiddles_i[tw1] + Fout2_i * this.twiddles_r[tw1];
            tw1 += fstride;
            Fout[Fout2 << 1] = Fout_r - t_r;
            Fout[(Fout2 << 1) + 1] = Fout_i - t_i;
            Fout[Fout_index << 1] = Fout_r + t_r;
            Fout[(Fout_index << 1) + 1] = Fout_i + t_i;
            ++Fout2;
            ++Fout_index;
        } while (--m != 0);
    }

    private void bfly4(double[] Fout, int Fout_index, int fstride, int m) {
        int k = m;
        int m2 = 2 * m;
        int m3 = 3 * m;
        int tw1 = 0;
        int tw2 = 0;
        int tw3 = 0;
        do {
            double scratch_0_r = Fout[Fout_index + m << 1] * this.twiddles_r[tw1] - Fout[(Fout_index + m << 1) + 1] * this.twiddles_i[tw1];
            double scratch_0_i = Fout[Fout_index + m << 1] * this.twiddles_i[tw1] + Fout[(Fout_index + m << 1) + 1] * this.twiddles_r[tw1];
            double scratch_1_r = Fout[Fout_index + m2 << 1] * this.twiddles_r[tw2] - Fout[(Fout_index + m2 << 1) + 1] * this.twiddles_i[tw2];
            double scratch_1_i = Fout[Fout_index + m2 << 1] * this.twiddles_i[tw2] + Fout[(Fout_index + m2 << 1) + 1] * this.twiddles_r[tw2];
            double scratch_2_r = Fout[Fout_index + m3 << 1] * this.twiddles_r[tw3] - Fout[(Fout_index + m3 << 1) + 1] * this.twiddles_i[tw3];
            double scratch_2_i = Fout[Fout_index + m3 << 1] * this.twiddles_i[tw3] + Fout[(Fout_index + m3 << 1) + 1] * this.twiddles_r[tw3];
            double scratch_5_r = Fout[Fout_index << 1] - scratch_1_r;
            double scratch_5_i = Fout[(Fout_index << 1) + 1] - scratch_1_i;
            Fout[Fout_index << 1] = Fout[Fout_index << 1] + scratch_1_r;
            Fout[(Fout_index << 1) + 1] = Fout[(Fout_index << 1) + 1] + scratch_1_i;
            double scratch_3_r = scratch_0_r + scratch_2_r;
            double scratch_3_i = scratch_0_i + scratch_2_i;
            double scratch_4_r = scratch_0_r - scratch_2_r;
            double scratch_4_i = scratch_0_i - scratch_2_i;
            Fout[Fout_index + m2 << 1] = Fout[Fout_index << 1] - scratch_3_r;
            Fout[(Fout_index + m2 << 1) + 1] = Fout[(Fout_index << 1) + 1] - scratch_3_i;
            tw1 += fstride;
            tw2 += fstride * 2;
            tw3 += fstride * 3;
            int n = Fout_index << 1;
            Fout[n] = Fout[n] + scratch_3_r;
            int n2 = (Fout_index << 1) + 1;
            Fout[n2] = Fout[n2] + scratch_3_i;
            if (this.inverse) {
                Fout[Fout_index + m << 1] = scratch_5_r - scratch_4_i;
                Fout[(Fout_index + m << 1) + 1] = scratch_5_i + scratch_4_r;
                Fout[Fout_index + m3 << 1] = scratch_5_r + scratch_4_i;
                Fout[(Fout_index + m3 << 1) + 1] = scratch_5_i - scratch_4_r;
            } else {
                Fout[Fout_index + m << 1] = scratch_5_r + scratch_4_i;
                Fout[(Fout_index + m << 1) + 1] = scratch_5_i - scratch_4_r;
                Fout[Fout_index + m3 << 1] = scratch_5_r - scratch_4_i;
                Fout[(Fout_index + m3 << 1) + 1] = scratch_5_i + scratch_4_r;
            }
            ++Fout_index;
        } while (--k != 0);
    }

    private void bfly3(double[] Fout, int Fout_index, int fstride, int m) {
        int k = m;
        int m2 = 2 * m;
        double epi3_i = this.twiddles_i[fstride * m];
        int tw2 = 0;
        int tw1 = 0;
        do {
            double scratch_1_r = Fout[Fout_index + m << 1] * this.twiddles_r[tw1] - Fout[(Fout_index + m << 1) + 1] * this.twiddles_i[tw1];
            double scratch_1_i = Fout[Fout_index + m << 1] * this.twiddles_i[tw1] + Fout[(Fout_index + m << 1) + 1] * this.twiddles_r[tw1];
            double scratch_2_r = Fout[Fout_index + m2 << 1] * this.twiddles_r[tw2] - Fout[(Fout_index + m2 << 1) + 1] * this.twiddles_i[tw2];
            double scratch_2_i = Fout[Fout_index + m2 << 1] * this.twiddles_i[tw2] + Fout[(Fout_index + m2 << 1) + 1] * this.twiddles_r[tw2];
            double scratch_3_r = scratch_1_r + scratch_2_r;
            double scratch_3_i = scratch_1_i + scratch_2_i;
            double scratch_0_r = scratch_1_r - scratch_2_r;
            double scratch_0_i = scratch_1_i - scratch_2_i;
            tw1 += fstride;
            tw2 += fstride * 2;
            Fout[Fout_index + m << 1] = Fout[Fout_index << 1] - scratch_3_r * 0.5;
            Fout[(Fout_index + m << 1) + 1] = Fout[(Fout_index << 1) + 1] - scratch_3_i * 0.5;
            scratch_0_i *= epi3_i;
            scratch_0_r *= epi3_i;
            int n = Fout_index << 1;
            Fout[n] = Fout[n] + scratch_3_r;
            int n2 = (Fout_index << 1) + 1;
            Fout[n2] = Fout[n2] + scratch_3_i;
            Fout[Fout_index + m2 << 1] = Fout[Fout_index + m << 1] + scratch_0_i;
            Fout[(Fout_index + m2 << 1) + 1] = Fout[(Fout_index + m << 1) + 1] - scratch_0_r;
            int n3 = Fout_index + m << 1;
            Fout[n3] = Fout[n3] - scratch_0_i;
            int n4 = (Fout_index + m << 1) + 1;
            Fout[n4] = Fout[n4] + scratch_0_r;
            ++Fout_index;
        } while (--k != 0);
    }

    private void bfly5(double[] Fout, int Fout_index, int fstride, int m) {
        double ya_r = this.twiddles_r[fstride * m];
        double ya_i = this.twiddles_i[fstride * m];
        double yb_r = this.twiddles_r[fstride * 2 * m];
        double yb_i = this.twiddles_i[fstride * 2 * m];
        int Fout0 = Fout_index;
        int Fout1 = Fout0 + m;
        int Fout2 = Fout0 + 2 * m;
        int Fout3 = Fout0 + 3 * m;
        int Fout4 = Fout0 + 4 * m;
        int u = 0;
        while (u < m) {
            double scratch_0_r = Fout[Fout0 << 1];
            double scratch_0_i = Fout[(Fout0 << 1) + 1];
            double scratch_1_r = Fout[Fout1 << 1] * this.twiddles_r[u * fstride] - Fout[(Fout1 << 1) + 1] * this.twiddles_i[u * fstride];
            double scratch_1_i = Fout[Fout1 << 1] * this.twiddles_i[u * fstride] + Fout[(Fout1 << 1) + 1] * this.twiddles_r[u * fstride];
            double scratch_2_r = Fout[Fout2 << 1] * this.twiddles_r[2 * u * fstride] - Fout[(Fout2 << 1) + 1] * this.twiddles_i[2 * u * fstride];
            double scratch_2_i = Fout[Fout2 << 1] * this.twiddles_i[2 * u * fstride] + Fout[(Fout2 << 1) + 1] * this.twiddles_r[2 * u * fstride];
            double scratch_3_r = Fout[Fout3 << 1] * this.twiddles_r[3 * u * fstride] - Fout[(Fout3 << 1) + 1] * this.twiddles_i[3 * u * fstride];
            double scratch_3_i = Fout[Fout3 << 1] * this.twiddles_i[3 * u * fstride] + Fout[(Fout3 << 1) + 1] * this.twiddles_r[3 * u * fstride];
            double scratch_4_r = Fout[Fout4 << 1] * this.twiddles_r[4 * u * fstride] - Fout[(Fout4 << 1) + 1] * this.twiddles_i[4 * u * fstride];
            double scratch_4_i = Fout[Fout4 << 1] * this.twiddles_i[4 * u * fstride] + Fout[(Fout4 << 1) + 1] * this.twiddles_r[4 * u * fstride];
            double scratch_7_r = scratch_1_r + scratch_4_r;
            double scratch_7_i = scratch_1_i + scratch_4_i;
            double scratch_10_r = scratch_1_r - scratch_4_r;
            double scratch_10_i = scratch_1_i - scratch_4_i;
            double scratch_8_r = scratch_2_r + scratch_3_r;
            double scratch_8_i = scratch_2_i + scratch_3_i;
            double scratch_9_r = scratch_2_r - scratch_3_r;
            double scratch_9_i = scratch_2_i - scratch_3_i;
            int n = Fout0 << 1;
            Fout[n] = Fout[n] + (scratch_7_r + scratch_8_r);
            int n2 = (Fout0 << 1) + 1;
            Fout[n2] = Fout[n2] + (scratch_7_i + scratch_8_i);
            double scratch_5_r = scratch_0_r + scratch_7_r * ya_r + scratch_8_r * yb_r;
            double scratch_5_i = scratch_0_i + scratch_7_i * ya_r + scratch_8_i * yb_r;
            double scratch_6_r = scratch_10_i * ya_i + scratch_9_i * yb_i;
            double scratch_6_i = -(scratch_10_r * ya_i) - scratch_9_r * yb_i;
            Fout[Fout1 << 1] = scratch_5_r - scratch_6_r;
            Fout[(Fout1 << 1) + 1] = scratch_5_i - scratch_6_i;
            Fout[Fout4 << 1] = scratch_5_r + scratch_6_r;
            Fout[(Fout4 << 1) + 1] = scratch_5_i + scratch_6_i;
            double scratch_11_r = scratch_0_r + scratch_7_r * yb_r + scratch_8_r * ya_r;
            double scratch_11_i = scratch_0_i + scratch_7_i * yb_r + scratch_8_i * ya_r;
            double scratch_12_r = -(scratch_10_i * yb_i) + scratch_9_i * ya_i;
            double scratch_12_i = scratch_10_r * yb_i - scratch_9_r * ya_i;
            Fout[Fout2 << 1] = scratch_11_r + scratch_12_r;
            Fout[(Fout2 << 1) + 1] = scratch_11_i + scratch_12_i;
            Fout[Fout3 << 1] = scratch_11_r - scratch_12_r;
            Fout[(Fout3 << 1) + 1] = scratch_11_i - scratch_12_i;
            ++Fout0;
            ++Fout1;
            ++Fout2;
            ++Fout3;
            ++Fout4;
            ++u;
        }
    }

    private void bfly_generic(double[] Fout, int Fout_index, int fstride, int m, int p) {
        int Norig = this.nfft;
        double[] scratchbuf_r = this.scratchbuf_r;
        double[] scratchbuf_i = this.scratchbuf_i;
        int u = 0;
        while (u < m) {
            int k = u;
            int q1 = 0;
            while (q1 < p) {
                scratchbuf_r[q1] = Fout[Fout_index + k << 1];
                scratchbuf_i[q1] = Fout[(Fout_index + k << 1) + 1];
                k += m;
                ++q1;
            }
            k = u;
            q1 = 0;
            while (q1 < p) {
                int twidx = 0;
                Fout[Fout_index + k << 1] = scratchbuf_r[0];
                Fout[(Fout_index + k << 1) + 1] = scratchbuf_i[0];
                int q = 1;
                while (q < p) {
                    if ((twidx += fstride * k) >= Norig) {
                        twidx -= Norig;
                    }
                    double t_r = scratchbuf_r[q] * this.twiddles_r[twidx] - scratchbuf_i[q] * this.twiddles_i[twidx];
                    double t_i = scratchbuf_r[q] * this.twiddles_i[twidx] + scratchbuf_i[q] * this.twiddles_r[twidx];
                    int n = Fout_index + k << 1;
                    Fout[n] = Fout[n] + t_r;
                    int n2 = (Fout_index + k << 1) + 1;
                    Fout[n2] = Fout[n2] + t_i;
                    ++q;
                }
                k += m;
                ++q1;
            }
            ++u;
        }
    }

    public void work(double[] Fout, int Fout_index, double[] f, int f_index, int fstride, int in_stride, int factors) {
        int Fout_beg_index = Fout_index;
        int p = this.factors[factors++];
        int m = this.factors[factors++];
        int Fout_end = Fout_index + p * m;
        if (m == 1) {
            do {
                Fout[Fout_index << 1] = f[f_index << 1];
                Fout[(Fout_index << 1) + 1] = f[(f_index << 1) + 1];
                f_index += fstride * in_stride;
            } while (++Fout_index != Fout_end);
        } else {
            do {
                this.work(Fout, Fout_index, f, f_index, fstride * p, in_stride, factors);
                f_index += fstride * in_stride;
            } while ((Fout_index += m) != Fout_end);
        }
        Fout_index = Fout_beg_index;
        switch (p) {
            case 2: {
                this.bfly2(Fout, Fout_index, fstride, m);
                break;
            }
            case 3: {
                this.bfly3(Fout, Fout_index, fstride, m);
                break;
            }
            case 4: {
                this.bfly4(Fout, Fout_index, fstride, m);
                break;
            }
            case 5: {
                this.bfly5(Fout, Fout_index, fstride, m);
                break;
            }
            default: {
                this.bfly_generic(Fout, Fout_index, fstride, m, p);
            }
        }
    }

    private void factor(int n, int[] facbuf) {
        int p = 4;
        double floor_sqrt = Math.floor(Math.sqrt(n));
        int i = 0;
        while (true) {
            if (n % p != 0) {
                switch (p) {
                    case 4: {
                        p = 2;
                        break;
                    }
                    case 2: {
                        p = 3;
                        break;
                    }
                    default: {
                        p += 2;
                    }
                }
                if (!((double)p > floor_sqrt)) continue;
                p = n;
                continue;
            }
            facbuf[i++] = p;
            facbuf[i++] = n /= p;
            if (n <= 1) break;
        }
    }

    public void transform_stride(double[] fin, double[] fout, int in_stride) {
        if (fin == fout) {
            if (this.tmpbuf == null) {
                this.tmpbuf = new double[this.nfft * 2];
            }
            this.work(this.tmpbuf, 0, fin, 0, 1, in_stride, 0);
            System.arraycopy(this.tmpbuf, 0, fout, 0, this.tmpbuf.length);
        } else {
            this.work(fout, 0, fin, 0, 1, in_stride, 0);
        }
    }

    public void transform(double[] fin, double[] fout) {
        this.transform_stride(fin, fout, 1);
    }

    public static int nextFastSize(int n) {
        while (true) {
            int m = ++n;
            while (m % 2 == 0) {
                m /= 2;
            }
            while (m % 3 == 0) {
                m /= 3;
            }
            while (m % 5 == 0) {
                m /= 5;
            }
            if (m <= 1) break;
        }
        return n;
    }
}

