/*
 * Decompiled with CFR 0.152.
 */
package rasmus.fft.fftw;

import java.nio.DoubleBuffer;
import rasmus.fft.FFTTransformer;
import rasmus.fft.fftw.FFTW;

class FFTWTransformer
implements FFTTransformer {
    FFTW fftw;
    DoubleBuffer in;
    DoubleBuffer out;

    public FFTWTransformer(int fftsize, int direction, boolean inplace) {
        this.fftw = direction == 1 ? new FFTW(fftsize, -1, 64) : new FFTW(fftsize, -1, 64);
        this.out = this.fftw.getOutput();
        this.in = this.fftw.getInput();
    }

    public void transform(double[] inout) {
        this.in.position(0);
        this.in.put(inout, 0, this.in.capacity());
        this.fftw.execute();
        this.out.position(0);
        this.out.get(inout, 0, this.out.capacity());
    }

    public void transform(double[] in, double[] out) {
        this.in.position(0);
        this.in.put(in, 0, this.in.capacity());
        this.fftw.execute();
        this.out.position(0);
        this.out.get(out, 0, this.out.capacity());
    }
}

