/*
 * Decompiled with CFR 0.152.
 */
package rasmus.fft;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import rasmus.fft.FFTTransformer;
import rasmus.fft.spi.FFTProvider;
import rasmus.util.RasmusUtil;

public class FFT {
    public static final int FORWARD = -1;
    public static final int BACKWARD = 1;
    public static final int REAL_TO_COMPLEX = -2;
    public static final int COMPLEX_TO_REAL = 2;
    private static FFTProvider[] providers;
    static /* synthetic */ Class class$0;

    static {
        FFT.init();
    }

    public static FFTProvider[] getProviders() {
        return providers;
    }

    public static void init() {
        List providers_list = RasmusUtil.getProviders(FFTProvider.class);
        Iterator iter = providers_list.iterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (!(obj instanceof FFTProvider)) {
                iter.remove();
                continue;
            }
            if (((FFTProvider)obj).getInfo() != null) continue;
            iter.remove();
        }
        providers = new FFTProvider[providers_list.size()];
        providers_list.toArray(providers);
        Arrays.sort(providers, new Comparator<FFTProvider>(){

            @Override
            public int compare(FFTProvider arg0, FFTProvider arg1) {
                return arg1.getInfo().getPriority() - arg0.getInfo().getPriority();
            }
        });
    }

    public static FFTTransformer getTransformer(int fftsize) {
        return FFT.getTransformer(fftsize, -1, true);
    }

    public static FFTTransformer getTransformer(int fftsize, int direction) {
        return FFT.getTransformer(fftsize, direction, true);
    }

    public static FFTTransformer getTransformer(int fftsize, int direction, boolean inplace) {
        int i = 0;
        while (i < providers.length) {
            FFTProvider provider = providers[i];
            FFTTransformer transformer = provider.getTransformer(fftsize, direction, inplace);
            if (transformer != null) {
                return transformer;
            }
            ++i;
        }
        return null;
    }

    public static FFTTransformer getTransformer(int[] dims) {
        return FFT.getTransformer(dims, -1, true);
    }

    public static FFTTransformer getTransformer(int[] dims, int direction) {
        return FFT.getTransformer(dims, direction, true);
    }

    public static FFTTransformer getTransformer(int[] dims, int direction, boolean inplace) {
        int i = 0;
        while (i < providers.length) {
            FFTProvider provider = providers[i];
            FFTTransformer transformer = provider.getTransformer(dims, direction, inplace);
            if (transformer != null) {
                return transformer;
            }
            ++i;
        }
        return null;
    }

    public static boolean isRadix2(int fftsize) {
        int x = (int)(Math.log(fftsize) / Math.log(2.0));
        return 1 << x == fftsize;
    }

    public static double[] wHanning(int fftFrameSize) {
        double[] window_table = new double[fftFrameSize];
        int k = 0;
        while (k < fftFrameSize) {
            window_table[k] = -0.5 * Math.cos(Math.PI * 2 * (double)k / (double)fftFrameSize) + 0.5;
            ++k;
        }
        return window_table;
    }

    public static double[] wHamming(int fftFrameSize) {
        double[] window_table = new double[fftFrameSize];
        int k = 0;
        while (k < fftFrameSize) {
            window_table[k] = -0.46 * Math.cos(Math.PI * 2 * (double)k / (double)fftFrameSize) + 0.54;
            ++k;
        }
        return window_table;
    }

    public static double[] wBlackman(int fftFrameSize) {
        double[] window_table = new double[fftFrameSize];
        int k = 0;
        while (k < fftFrameSize) {
            window_table[k] = -0.5 * Math.cos(Math.PI * 2 * (double)k / (double)fftFrameSize) + 0.08 * Math.cos(Math.PI * 4 * (double)k / (double)fftFrameSize) + 0.42;
            ++k;
        }
        return window_table;
    }
}

