/*
 * Decompiled with CFR 0.152.
 */
package rasmus.editor;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import rasmus.interpreter.Variable;
import rasmus.interpreter.sampled.AudioSession;
import rasmus.interpreter.sampled.AudioStream;

class WavePanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    boolean eof = false;
    long writepos = 0L;
    int totalsize = 0;
    int buffersize;
    double[] doublebuffer;
    ByteBuffer bytebuffer;
    DoubleBuffer doubleview;
    File tempfile;
    File tempfile2;
    RandomAccessFile randomfile;
    RandomAccessFile randomfile2;
    AudioSession session = null;
    AudioStream stream = null;
    boolean isreading = false;
    boolean isreseting = false;

    protected void paintComponent(Graphics graphics) {
        int ret;
        super.paintComponent(graphics);
        if (this.isreading) {
            return;
        }
        Rectangle clip = graphics.getClipBounds();
        int height = this.getHeight();
        int from = clip.x;
        int to = from + clip.width;
        try {
            this.randomfile.seek(from);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        int bufflen = to - from;
        ByteBuffer bytebuffer = ByteBuffer.allocate(bufflen * 8);
        try {
            ret = this.randomfile.read(bytebuffer.array(), 0, (to - from) * 8);
        }
        catch (IOException e) {
            e.printStackTrace();
            ret = 0;
        }
        double[] dbuffer = new double[bufflen];
        bytebuffer.asDoubleBuffer().get(dbuffer);
        bufflen = ret / 8;
        graphics.setColor(Color.GREEN);
        int i = 0;
        while (i < bufflen) {
            int x = i + from;
            int y = (int)((double)height * (-dbuffer[i] * 0.5 + 0.5));
            graphics.drawLine(x, y, x, y);
            ++i;
        }
        if (!this.eof && this.totalsize < to) {
            this.read(to - this.totalsize);
        }
    }

    public WavePanel() {
        this.setBackground(Color.BLACK);
        try {
            this.tempfile = File.createTempFile("rasmusdsp_", "_audiobuffer.float");
            this.tempfile2 = File.createTempFile("rasmusdsp_", "_audiobuffer.float2");
            this.randomfile = new RandomAccessFile(this.tempfile, "rw");
            this.randomfile2 = new RandomAccessFile(this.tempfile2, "rw");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setVariable(Variable variable) {
        this.reset();
        AudioSession session = new AudioSession(44100.0, 1);
        this.stream = session.openStream(variable);
        this.buffersize = 4096;
        this.buffersize -= this.buffersize % session.getChannels();
        this.doublebuffer = new double[this.buffersize];
        this.bytebuffer = ByteBuffer.allocate(this.buffersize * 8);
        this.doubleview = this.bytebuffer.asDoubleBuffer();
    }

    public void read(long len) {
        if (this.isreseting) {
            return;
        }
        this.isreading = true;
        WaveReader runnable = new WaveReader();
        runnable.len = len;
        new Thread(runnable).start();
    }

    public void readStream(long len) {
        try {
            while (len > 0L) {
                len -= (long)this.buffersize;
                int ret = this.stream.replace(this.doublebuffer, 0, this.buffersize);
                if (ret == -1) {
                    this.stream.close();
                    this.stream = null;
                    this.eof = true;
                    return;
                }
                this.randomfile.seek(this.writepos);
                this.doubleview.position(0);
                this.doubleview.put(this.doublebuffer);
                this.randomfile.write(this.bytebuffer.array(), 0, ret * 8);
                this.totalsize += ret;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            this.eof = true;
        }
        this.repaint();
    }

    public void reset() {
        this.isreseting = true;
        while (this.isreading) {
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                break;
            }
        }
        if (this.stream != null) {
            this.stream.close();
            this.stream = null;
        }
        if (this.session != null) {
            this.session.close();
            this.session = null;
        }
        try {
            this.randomfile.setLength(0L);
            this.randomfile2.setLength(0L);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.writepos = 0L;
        this.eof = false;
        this.totalsize = 0;
        this.isreseting = false;
    }

    public void close() {
        this.reset();
        try {
            this.randomfile.close();
            this.tempfile.delete();
            this.randomfile2.close();
            this.tempfile2.delete();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    class WaveReader
    implements Runnable {
        int step = 1;
        long len;

        WaveReader() {
        }

        public void run() {
            if (this.step == 1) {
                this.run1();
            }
            if (this.step == 2) {
                this.run2();
            }
        }

        public void run1() {
            WavePanel.this.readStream(this.len);
            this.step = 2;
            SwingUtilities.invokeLater(this);
        }

        public void run2() {
            WavePanel.this.isreading = false;
            WavePanel.this.repaint();
        }
    }
}

