/*
 * Decompiled with CFR 0.152.
 */
package rasmus.editor;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.text.JTextComponent;

public class TextPopupMenu {
    JTextComponent textcomp;
    JPopupMenu popupmenu;

    public static JPopupMenu createPopupMenu(JTextComponent comp) {
        TextPopupMenu textpopupmenu = new TextPopupMenu();
        textpopupmenu.textcomp = comp;
        textpopupmenu.init();
        return textpopupmenu.popupmenu;
    }

    public static JPopupMenu addPopupMenu(JTextComponent comp) {
        PopupMenuListener listener = new PopupMenuListener(comp);
        comp.addMouseListener(listener);
        return listener.textpopupmenu;
    }

    private void init() {
        this.popupmenu = new JPopupMenu();
        Action undo_action = this.textcomp.getActionMap().get("Undo");
        if (undo_action != null) {
            JMenuItem menu_undo = new JMenuItem("Undo");
            menu_undo.setMnemonic('U');
            menu_undo.setAccelerator(KeyStroke.getKeyStroke("control Z"));
            menu_undo.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent arg0) {
                    Action undo_action = TextPopupMenu.this.textcomp.getActionMap().get("Undo");
                    if (undo_action != null) {
                        undo_action.actionPerformed(arg0);
                    }
                }
            });
            this.popupmenu.add(menu_undo);
            this.popupmenu.addSeparator();
        }
        JMenuItem menu_cut = new JMenuItem("Cut");
        menu_cut.setMnemonic('t');
        menu_cut.setAccelerator(KeyStroke.getKeyStroke("control X"));
        menu_cut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                TextPopupMenu.this.textcomp.cut();
            }
        });
        JMenuItem menu_copy = new JMenuItem("Copy");
        menu_copy.setMnemonic('c');
        menu_copy.setAccelerator(KeyStroke.getKeyStroke("control C"));
        menu_copy.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                TextPopupMenu.this.textcomp.copy();
            }
        });
        JMenuItem menu_paste = new JMenuItem("Paste");
        menu_paste.setMnemonic('p');
        menu_paste.setAccelerator(KeyStroke.getKeyStroke("control V"));
        menu_paste.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                TextPopupMenu.this.textcomp.paste();
            }
        });
        JMenuItem menu_delete = new JMenuItem("Delete");
        menu_delete.setMnemonic('d');
        menu_delete.setAccelerator(KeyStroke.getKeyStroke("DELETE"));
        menu_delete.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                TextPopupMenu.this.textcomp.replaceSelection("");
            }
        });
        JMenuItem menu_selectAll = new JMenuItem("Select All");
        menu_selectAll.setMnemonic('A');
        menu_selectAll.setAccelerator(KeyStroke.getKeyStroke("control A"));
        menu_selectAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                TextPopupMenu.this.textcomp.selectAll();
            }
        });
        this.popupmenu.add(menu_cut);
        this.popupmenu.add(menu_copy);
        this.popupmenu.add(menu_paste);
        this.popupmenu.add(menu_delete);
        this.popupmenu.addSeparator();
        this.popupmenu.add(menu_selectAll);
    }

    private static class PopupMenuListener
    implements MouseListener {
        JTextComponent comp;
        JPopupMenu textpopupmenu;

        public PopupMenuListener(JTextComponent comp) {
            this.comp = comp;
            this.textpopupmenu = TextPopupMenu.createPopupMenu(comp);
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.comp.grabFocus();
                this.textpopupmenu.show((JComponent)e.getSource(), e.getX(), e.getY());
            }
        }
    }
}

