/*
 * Decompiled with CFR 0.152.
 */
package rasmus.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.Document;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import rasmus.editor.TextPopupMenu;
import rasmus.interpreter.Interpreter;
import rasmus.interpreter.metadata.FunctionCallEditor;
import rasmus.interpreter.ui.GroupMenuListener;
import rasmus.interpreter.ui.GroupMenus;
import rasmus.interpreter.ui.RSyntaxDocument;
import rasmus.interpreter.ui.RegisterFunction;
import rasmus.interpreter.ui.RegisterUnit;

public class ExpressionEditor
extends JDialog {
    private static final long serialVersionUID = 1L;
    JTextPane textarea = new JTextPane();
    UndoManager undo = new UndoManager();
    Interpreter globalinterpreter = new Interpreter();
    JPopupMenu insert_popup;
    JButton insert_function_button;
    JButton arguments_button;
    GroupMenuListener groupmenulistener = new GroupMenuListener(){

        public void actionPerformed(RegisterUnit.Record record) {
            if (record.unit instanceof RegisterFunction) {
                if (FunctionCallEditor.isEditableFunction(record.name, ExpressionEditor.this.globalinterpreter)) {
                    String statement = FunctionCallEditor.editFunctionCall(ExpressionEditor.this, String.valueOf(record.name) + "()", ExpressionEditor.this.globalinterpreter);
                    if (statement != null) {
                        ExpressionEditor.this.textarea.replaceSelection(statement);
                    }
                    return;
                }
                ExpressionEditor.this.textarea.replaceSelection(String.valueOf(record.name) + "()");
                return;
            }
            ExpressionEditor.this.textarea.replaceSelection(record.name);
        }
    };
    boolean ok = false;

    private ExpressionEditor(Frame parent) {
        super(parent);
        this.textarea.setDocument(new RSyntaxDocument(this.globalinterpreter));
        this.textarea.setFont(new Font("Courier", 0, 12));
        Document doc = this.textarea.getDocument();
        doc.addUndoableEditListener(new UndoableEditListener(){

            public void undoableEditHappened(UndoableEditEvent evt) {
                ExpressionEditor.this.undo.addEdit(evt.getEdit());
            }
        });
        ActionMap textarea_actionmap = this.textarea.getActionMap();
        InputMap textarea_inputmap = this.textarea.getInputMap();
        textarea_inputmap.put(KeyStroke.getKeyStroke("control Z"), "Undo");
        textarea_inputmap.put(KeyStroke.getKeyStroke("control Y"), "Redo");
        textarea_actionmap.put("Undo", new AbstractAction("Undo"){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent evt) {
                try {
                    if (ExpressionEditor.this.undo.canUndo()) {
                        ExpressionEditor.this.undo.undo();
                    }
                }
                catch (CannotUndoException cannotUndoException) {
                    // empty catch block
                }
            }
        });
        textarea_actionmap.put("Redo", new AbstractAction("Redo"){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent evt) {
                try {
                    if (ExpressionEditor.this.undo.canRedo()) {
                        ExpressionEditor.this.undo.redo();
                    }
                }
                catch (CannotRedoException cannotRedoException) {
                    // empty catch block
                }
            }
        });
        TextPopupMenu.addPopupMenu(this.textarea);
        GroupMenus groupmenu = new GroupMenus(this.globalinterpreter, this.groupmenulistener);
        this.insert_popup = new JPopupMenu();
        Component[] menucomps = groupmenu.getMenuComponents();
        groupmenu.removeAll();
        int i = 0;
        while (i < menucomps.length) {
            this.insert_popup.add(menucomps[i]);
            ++i;
        }
        this.insert_function_button = new JButton("Insert Function...");
        this.insert_function_button.setFocusable(false);
        this.insert_function_button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                ExpressionEditor.this.insert_popup.show(ExpressionEditor.this.insert_function_button, 0, 0);
            }
        });
        this.arguments_button = new JButton("Arguments...");
        this.arguments_button.setFocusable(false);
        ActionListener arguments_action = new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                try {
                    int start = ExpressionEditor.this.textarea.getSelectionStart();
                    int[] pair = ((RSyntaxDocument)ExpressionEditor.this.textarea.getDocument()).extractFunctionCall(start);
                    if (pair == null) {
                        return;
                    }
                    ExpressionEditor.this.textarea.select(pair[0], pair[0] + pair[1]);
                    String token = ExpressionEditor.this.textarea.getDocument().getText(pair[0], pair[1]);
                    String expr = FunctionCallEditor.editFunctionCall(ExpressionEditor.this, token, ExpressionEditor.this.globalinterpreter);
                    if (expr != null) {
                        ExpressionEditor.this.textarea.replaceSelection(expr);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        this.arguments_button.addActionListener(arguments_action);
        KeyStroke stroke_f4 = KeyStroke.getKeyStroke(115, 0);
        this.textarea.registerKeyboardAction(arguments_action, stroke_f4, 2);
        JButton okbutton = new JButton("OK");
        okbutton.setDefaultCapable(true);
        okbutton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                ExpressionEditor.this.ok = true;
                ExpressionEditor.this.setVisible(false);
            }
        });
        JButton cancelbutton = new JButton("Cancel");
        cancelbutton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                ExpressionEditor.this.setVisible(false);
            }
        });
        JPanel buttonpanelL = new JPanel();
        buttonpanelL.setLayout(new FlowLayout(0));
        buttonpanelL.add(this.insert_function_button);
        buttonpanelL.add(this.arguments_button);
        JPanel buttonpanelR = new JPanel();
        buttonpanelR.setLayout(new FlowLayout(2));
        buttonpanelR.add(okbutton);
        buttonpanelR.add(cancelbutton);
        JPanel buttonpanel = new JPanel();
        buttonpanel.setLayout(new BorderLayout());
        buttonpanel.add(buttonpanelL);
        buttonpanel.add((Component)buttonpanelR, "East");
        JPanel textpanel = new JPanel();
        textpanel.setLayout(new BorderLayout());
        textpanel.add(this.textarea);
        JScrollPane scrollpane = new JScrollPane(textpanel);
        this.setLayout(new BorderLayout());
        this.add(scrollpane);
        this.add((Component)buttonpanel, "South");
        this.getRootPane().setDefaultButton(okbutton);
        KeyStroke stroke = KeyStroke.getKeyStroke(27, 0);
        scrollpane.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ExpressionEditor.this.setVisible(false);
            }
        }, stroke, 2);
        this.setTitle("Expression Editor");
        Dimension size = new Dimension(500, 300);
        this.setSize(size);
        Dimension screenSize = parent.getSize();
        Point parent_loc = parent.getLocation();
        this.setLocation(parent_loc.x + screenSize.width / 2 - size.width / 2, parent_loc.y + screenSize.height / 2 - size.height / 2);
    }

    public static String editScript(Frame parent, String string) {
        ExpressionEditor ee = new ExpressionEditor(parent);
        ee.setModal(true);
        ee.textarea.setText(string);
        ee.setVisible(true);
        if (!ee.ok) {
            return null;
        }
        return ee.textarea.getText();
    }
}

