/*
 * Decompiled with CFR 0.152.
 */
package examples.cli;

import com.vwp.sound.mod.modplay.PlayList;
import com.vwp.sound.mod.modplay.Scope;
import com.vwp.sound.mod.sound.output.JavaSoundOutput;
import com.vwp.sound.mod.sound.output.Output;
import com.vwp.sound.mod.sound.output.SoundDataFormat;
import com.vwp.sound.mod.sound.output.WavOutput;
import com.vwp.sound.mod.util.Util;
import java.util.StringTokenizer;

public class Player {
    private static com.vwp.sound.mod.modplay.Player player;
    private static boolean random;
    private static int channels;
    private static String modName;
    private static boolean interpolate;
    private static int rate;
    private static int bits;
    private static double volume;
    private static double balance;
    private static double separation;
    private static int bufferTime;
    private static boolean[] mute;
    private static int startPosition;
    private static boolean onlyInfo;
    private static boolean verbose;
    private static boolean debug;
    private static double amplification;
    private static boolean writewav;
    private static long maxtime;
    private static String bug;
    private static String usage;

    static {
        random = false;
        channels = 2;
        interpolate = true;
        rate = 44100;
        bits = 16;
        volume = 1.0;
        balance = 0.5;
        separation = -1.0;
        bufferTime = 500;
        mute = new boolean[256];
        startPosition = 0;
        onlyInfo = false;
        verbose = true;
        debug = false;
        amplification = -1.0;
        writewav = false;
        maxtime = -1L;
        bug = "\nAn error has occured. Please report bugs at:\nhttps://jmod.dev.java.net/\nor email oxygenic@jmod.dev.java.net\n";
        usage = "usage:  java com.vwp.sound.mod.modplay.Player [options] <modname|playlist>\n        modname is the filename of a module (.mod or .xm)\n        playlist a file containing a list of modules separated by newlines\noptions:\n\tampX            - set amplification in percent, (0 - inf)\n\t                  [#tracks*100/4]\n\tbalanceX        - set balance, (-100 - 100) [0]\n\tbitsX           - 8 or 16 bits playback [16]\n\tbufferX         - set size of buffer to X milliseconds [500]\n\tdebug           - display debug information\n\tinfo            - show module info, don't play\n\tnoint           - don't use interpolation\n\tmaxtimeX        - exit/go to the module itf it has been\n\t                  playing for more than X minutes\n\tmono            - play module in mono\n\tmuteX[:Y...]    - mute track X [and Y and...]\n\tpatternX        - start playing at pattern X [0]\n\tquiet           - don't display any information\n\trandom          - play modules from the playlist in random order\n\trateX           - mix at rate X (X = <11025|22050|44100>) [44100]\n\tseperationX     - set the seperation of the channels.\n\t                  0 = mono, 100 = \"total\" stereo (0-100)\n\t                  [100 for .xm, 50 for .mod]\n\tvolumeX         - set volume to X (0-100) [100]\n\twav             - write to a wav file instead of speakers\n";
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println(usage);
            Util.exit(1);
        }
        try {
            PlayList pl = null;
            pl = Player.isList(args[args.length - 1]) ? new PlayList(args[args.length - 1]) : new PlayList(new String[]{args[args.length - 1]});
            while (pl.hasNext()) {
                Player.initialize(args, pl);
                player = new com.vwp.sound.mod.modplay.Player();
                SoundDataFormat sdf = new SoundDataFormat(bits, rate, channels);
                Output out = writewav ? new WavOutput(String.valueOf(modName) + ".wav", sdf) : new JavaSoundOutput(sdf, bufferTime);
                if (!player.init(out, interpolate)) {
                    throw new Exception("could not init player");
                }
                if (!player.load(modName)) {
                    throw new Exception("could not load module");
                }
                if (onlyInfo) continue;
                player.setPosition(startPosition);
                player.setBalance(balance);
                player.setVolume(volume);
                player.setSeparation(separation);
                if (amplification >= 0.0) {
                    player.setAmplification(amplification);
                }
                player.mute(mute);
                int tracks = player.getModule().getTrackCount();
                Scope scope = new Scope(tracks, bufferTime + 200);
                long startTime = System.currentTimeMillis();
                while (maxtime == -1L || System.currentTimeMillis() - startTime <= maxtime) {
                    int position = player.getPosition();
                    int division = player.getDivision();
                    int tick = player.getTick();
                    if (tick == 0) {
                        scope.next();
                        int n = 0;
                        while (n < tracks) {
                            if (player.getNote(n) != -2) {
                                scope.poke(n);
                            }
                            ++n;
                        }
                    }
                    if (player.play()) continue;
                }
                player.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("\n" + bug);
            System.exit(1);
        }
        Util.exit(0);
    }

    private static void initialize(String[] args, PlayList pl) throws Exception {
        int i = 0;
        while (i < args.length - 1) {
            if (args[i].startsWith("amp")) {
                amplification = (double)Integer.parseInt(args[i].substring(3)) / 100.0;
            } else if (args[i].equalsIgnoreCase("quiet")) {
                verbose = false;
            } else if (args[i].equalsIgnoreCase("debug")) {
                debug = true;
            } else if (args[i].equalsIgnoreCase("info")) {
                onlyInfo = true;
            } else if (args[i].startsWith("mute")) {
                StringTokenizer st = new StringTokenizer(args[i].substring(4), ":");
                while (st.hasMoreTokens()) {
                    Player.mute[Integer.parseInt((String)st.nextToken())] = true;
                }
            } else if (args[i].startsWith("mono")) {
                channels = 1;
            } else if (args[i].startsWith("pattern")) {
                startPosition = Integer.parseInt(args[i].substring(7));
            } else if (args[i].startsWith("rate")) {
                int r = Integer.parseInt(args[i].substring(4));
                if (r != 11025 && r != 44100 && r != 22050) {
                    throw new Exception("rate must be 11025, 22050 or 44100");
                }
                rate = r;
            } else if (args[i].startsWith("bits")) {
                int b = Integer.parseInt(args[i].substring(4));
                if (b != 8 && b != 16) {
                    throw new Exception("bits must be 8 or 16");
                }
                bits = b;
            } else if (args[i].equals("random")) {
                random = true;
            } else if (args[i].startsWith("noint")) {
                interpolate = false;
            } else if (args[i].startsWith("maxtime")) {
                maxtime = Integer.parseInt(args[i].substring(7)) * 60 * 1000;
            } else if (args[i].startsWith("volume")) {
                int v = Integer.parseInt(args[i].substring(6));
                if (v < 0 || v > 255) {
                    throw new Exception("volume must be 0-100");
                }
                volume = (double)v / 100.0;
            } else if (args[i].startsWith("balance")) {
                int b = Integer.parseInt(args[i].substring(7));
                if (b < -100 || b > 100) {
                    throw new Exception("balance must be -100 - 100");
                }
                balance = (double)b / 200.0 + 0.5;
            } else if (args[i].startsWith("seperation")) {
                int s = Integer.parseInt(args[i].substring(10));
                if (s < 0 || s > 100) {
                    throw new Exception("seperation must be 0-100");
                }
                separation = (double)s / 100.0;
            } else if (args[i].startsWith("buffer")) {
                int t;
                bufferTime = t = Integer.parseInt(args[i].substring(6));
            } else if (args[i].equalsIgnoreCase("wav")) {
                writewav = true;
            }
            ++i;
        }
        modName = !random ? pl.nextFileName() : pl.getRandomFileName();
        if (separation == -1.0) {
            if (modName.toLowerCase().endsWith(".xm")) {
                separation = 1.0;
            } else if (modName.toLowerCase().endsWith(".mod")) {
                separation = 0.5;
            } else if (modName.toLowerCase().endsWith(".s3m")) {
                separation = 1.0;
            }
        }
    }

    private static boolean isList(String name) {
        return name.toLowerCase().endsWith(".lst") || name.toLowerCase().endsWith(".list") || name.toLowerCase().endsWith(".txt");
    }

    private static String pad(int value, int len) {
        StringBuffer sb = new StringBuffer();
        int val = value;
        int count = 0;
        while (val != 0 && count++ < len) {
            sb.insert(0, val % 10);
            val /= 10;
        }
        while (count++ < len) {
            sb.insert(0, '0');
        }
        return sb.toString();
    }
}

