/*
 * Decompiled with CFR 0.152.
 */
package com.vwp.sound.mod.modplay.player;

import com.vwp.sound.mod.modplay.module.Instrument;
import com.vwp.sound.mod.modplay.module.Module;
import com.vwp.sound.mod.modplay.module.Sample;
import com.vwp.sound.mod.modplay.module.Track;
import com.vwp.sound.mod.modplay.player.Mixer;
import com.vwp.sound.mod.modplay.player.ModuleState;
import com.vwp.sound.mod.modplay.player.PlayerException;
import com.vwp.sound.mod.modplay.player.autoeffect.AutoEffect;
import com.vwp.sound.mod.modplay.player.autoeffect.Envelope;
import com.vwp.sound.mod.modplay.player.effect.LocalEffects;

public class TrackState {
    private ModuleState moduleState;
    private Module module;
    private Mixer mixer;
    private LocalEffects effects;
    private int trackNumber;
    private double volume;
    private double panning;
    private int note;
    private double relativeNote;
    private double fineTune;
    private int instrument;
    private double sampleOffset;
    private Sample sample;
    private int loopType;
    private int loopStart;
    private int loopLength;
    private int sampleDelay;
    private double envelopeVolume;
    private double fadeoutVolume;
    private double envelopePanning;
    private AutoEffect[] autoEffects;

    public TrackState(ModuleState moduleState, Module module, Mixer mixer, int trackNumber) {
        this.moduleState = moduleState;
        this.module = module;
        this.mixer = mixer;
        this.effects = new LocalEffects();
        this.trackNumber = trackNumber;
        this.panning = module.getInitialPanning(trackNumber);
        this.note = -2;
        this.instrument = -1;
        this.sampleDelay = 0;
        this.envelopeVolume = 1.0;
        this.fadeoutVolume = 1.0;
        this.envelopePanning = 0.5;
    }

    public void preEffect(int pattern, int division, int tick) {
        Track track = this.module.getPatternAtPos(pattern).getTrack(this.trackNumber);
        int m = 0;
        while (m < track.getNumberOfEffects(division)) {
            int effNum = track.getEffect(division, m);
            int arg1 = track.getEffectArg1(division, m);
            int arg2 = track.getEffectArg2(division, m);
            this.effects.preEffect(this, this.trackNumber, pattern, division, tick, effNum, arg1, arg2);
            ++m;
        }
    }

    public void loadTick(int pattern, int division, int tick) {
        if (tick == this.sampleDelay) {
            this.sampleDelay = 0;
            int newNote = this.getNote(pattern, division, this.trackNumber);
            int newInstrument = this.getInstrument(pattern, division, this.trackNumber);
            if (newNote != -2 && !this.noteIsArgument(pattern, division, this.trackNumber) && newInstrument != -1) {
                this.newNoteAndInstrument(newNote, newInstrument);
            } else if (newNote != -2 && !this.noteIsArgument(pattern, division, this.trackNumber) && newInstrument == -1) {
                this.newNote(newNote);
            } else if ((newNote == -2 || this.noteIsArgument(pattern, division, this.trackNumber)) && newInstrument != -1) {
                this.newInstrument(newInstrument);
            }
        }
    }

    public void doEffects(int pattern, int division, int tick) {
        Track track = this.module.getPatternAtPos(pattern).getTrack(this.trackNumber);
        int m = 0;
        while (m < track.getNumberOfEffects(division)) {
            int effNum = track.getEffect(division, m);
            int arg1 = track.getEffectArg1(division, m);
            int arg2 = track.getEffectArg2(division, m);
            this.effects.doEffect(this, this.trackNumber, pattern, division, tick, effNum, arg1, arg2);
            ++m;
        }
        this.envelopeVolume = 1.0;
        this.fadeoutVolume = 1.0;
        this.envelopePanning = 0.5;
        int n = 0;
        while (this.autoEffects != null && n < this.autoEffects.length) {
            this.autoEffects[n].doEffect(this, this.trackNumber);
            ++n;
        }
    }

    public void setupMixer(int pattern, int division, int tick, double time) throws PlayerException {
        double rate = this.sample != null ? this.sample.getUnits().note2rate((double)this.note + this.fineTune + this.relativeNote + this.effects.noteTune + this.effects.noteSlide) : 0.0;
        double vol = (this.volume + this.effects.volumeSlide + this.effects.tremoloValue) * this.envelopeVolume * this.fadeoutVolume;
        if (vol < 0.0) {
            vol = 0.0;
        } else if (vol > 1.0) {
            vol = 1.0;
        }
        double pan = this.panning + this.effects.panningSlide;
        pan += Math.min(pan, 1.0 - pan) * (this.envelopePanning - 0.5) * 2.0;
        if (pan < 0.0) {
            pan = 0.0;
        } else if (pan > 1.0) {
            pan = 1.0;
        }
        this.mixer.setTrack(this.sample != null ? this.sample.getData() : null, this.sampleOffset, rate, vol, pan, this.loopType, this.loopStart, this.loopLength, this.trackNumber);
        this.sampleOffset += time * rate / 1000.0;
    }

    public void postEffects(int pattern, int division, int tick) {
        Track track = this.module.getPatternAtPos(pattern).getTrack(this.trackNumber);
        int m = 0;
        while (m < track.getNumberOfEffects(division)) {
            int effNum = track.getEffect(division, m);
            int arg1 = track.getEffectArg1(division, m);
            int arg2 = track.getEffectArg2(division, m);
            this.effects.postEffect(this, this.trackNumber, pattern, division, tick, effNum, arg1, arg2);
            ++m;
        }
    }

    public ModuleState getModuleState() {
        return this.moduleState;
    }

    public Module getModule() {
        return this.module;
    }

    public void setVolume(double vol) {
        this.volume = vol;
    }

    public double getVolume() {
        return this.volume;
    }

    public void setPanning(double pan) {
        this.panning = pan;
    }

    public void setFineTune(double tune) {
        this.fineTune = tune;
    }

    public void setSampleOffset(double offset) {
        this.sampleOffset = offset;
    }

    public void setSampleDelay(int delay) {
        this.sampleDelay = delay;
    }

    public void setEnvelopePosition(int pos) {
        int n = 0;
        while (this.autoEffects != null && n < this.autoEffects.length) {
            if (this.autoEffects[n] instanceof Envelope) {
                ((Envelope)this.autoEffects[n]).setPosition(pos, this.trackNumber);
            }
            ++n;
        }
    }

    public int getNote() {
        return this.note;
    }

    public void setEnvelopePanning(double envPan) {
        this.envelopePanning = envPan;
    }

    public void setEnvelopeVolume(double envVol) {
        this.envelopeVolume = envVol;
    }

    public void setFadeoutVolume(double fadeVol) {
        this.fadeoutVolume = fadeVol;
    }

    private boolean noteIsArgument(int pattern, int division, int trackNumber) {
        Track track = this.module.getPatternAtPos(pattern).getTrack(trackNumber);
        int n = 0;
        while (n < track.getNumberOfEffects(division)) {
            int effect = track.getEffect(division, n);
            if (effect == 3 || effect == 42) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private int getNote(int pattern, int division, int trackNumber) {
        Track track = this.module.getPatternAtPos(pattern).getTrack(trackNumber);
        int tmpNote = track.getNote(division);
        return tmpNote;
    }

    private int getInstrument(int pattern, int division, int trackNumber) {
        Track track = this.module.getPatternAtPos(pattern).getTrack(trackNumber);
        int tmpInstrument = track.getInstrumentNumber(division);
        return tmpInstrument;
    }

    private Sample getSample(int instrument, int note) {
        Instrument instr = this.module.getInstrument(instrument);
        Sample sample = null;
        if (instr != null) {
            sample = instr.getSampleByNote(note);
        }
        return sample;
    }

    private void newNoteAndInstrument(int newNote, int newInstrument) {
        this.effects.newNoteAndInstrument(newNote, newInstrument);
        this.note = newNote;
        this.instrument = newInstrument;
        Sample sample = this.getSample(this.instrument, this.note);
        if (sample != null) {
            this.fineTune = sample.getFineTune();
            this.relativeNote = sample.getRelativeNote();
            this.sample = sample;
            this.volume = sample.getVolume();
            if (this.module.getPanningType() == 2) {
                this.panning = sample.getPanning();
            } else if (this.module.getPanningType() == 1) {
                this.panning = this.module.getInitialPanning(this.trackNumber);
            } else if (this.module.getPanningType() == 3) {
                this.panning = this.module.getInstrument(this.instrument).getPanning();
            }
            this.loopType = sample.getLoopType();
            this.loopStart = sample.getLoopStart();
            this.loopLength = sample.getLoopLength();
        } else {
            this.fineTune = 0.0;
            this.relativeNote = 0.0;
            this.sample = null;
            this.volume = 1.0;
            this.panning = this.module.getInitialPanning(this.trackNumber);
        }
        this.sampleOffset = 0.0;
        Instrument instr = this.module.getInstrument(this.instrument);
        if (instr != null) {
            this.autoEffects = instr.getAutoEffects();
        }
        int n = 0;
        while (this.autoEffects != null && n < this.autoEffects.length) {
            this.autoEffects[n].reset(this.trackNumber);
            this.autoEffects[n].newNote(newNote, this.trackNumber);
            ++n;
        }
    }

    private void newNote(int newNote) {
        this.effects.newNote(newNote);
        int n = 0;
        while (this.autoEffects != null && n < this.autoEffects.length) {
            this.autoEffects[n].newNote(newNote, this.trackNumber);
            ++n;
        }
        this.note = newNote;
        Sample sample = this.getSample(this.instrument, this.note);
        if (sample != null) {
            this.fineTune = sample.getFineTune();
            this.relativeNote = sample.getRelativeNote();
            this.sample = sample;
            this.loopType = sample.getLoopType();
            this.loopStart = sample.getLoopStart();
            this.loopLength = sample.getLoopLength();
        } else {
            this.fineTune = 0.0;
            this.relativeNote = 0.0;
            sample = null;
        }
        this.sampleOffset = 0.0;
    }

    private void newInstrument(int newInstrument) {
        this.volume = 1.0;
        this.panning = this.module.getInitialPanning(this.trackNumber);
    }

    public Sample getSample() {
        return this.sample;
    }

    public int getInstrument() {
        return this.instrument;
    }
}

