/*
 * Decompiled with CFR 0.152.
 */
package com.vwp.sound.mod.modplay.module;

import com.vwp.sound.mod.modplay.module.ModuleUnits;

public class Sample {
    private String id;
    private String name;
    private double volume;
    private double panning;
    private int length;
    private int loopType;
    private int loopStart;
    private int loopLength;
    private double relativeNote;
    private double fineTune;
    private ModuleUnits units;
    private short[] data;
    public static final int NO_LOOP = 0;
    public static final int FORWARD = 1;
    public static final int PING_PONG = 2;

    public Sample(String id, String name, double volume, double panning, int length, int loopType, int loopStart, int loopLength, double relativeNote, double fineTune, ModuleUnits units) {
        this.id = id;
        this.name = name;
        this.volume = volume;
        if (panning < 0.0) {
            panning = 0.0;
        }
        if (panning > 1.0) {
            panning = 1.0;
        }
        this.panning = panning;
        this.length = length;
        this.loopType = loopType;
        this.loopStart = loopStart;
        this.loopLength = loopLength;
        this.relativeNote = relativeNote;
        this.fineTune = fineTune;
        this.units = units;
    }

    public String getInfo() {
        StringBuffer sb = new StringBuffer();
        sb.append("Sample name: " + this.name + "\n");
        sb.append("Length: " + this.length + "\n");
        String loop = null;
        if (this.loopType == 0) {
            loop = "no loop ";
        } else if (this.loopType == 1) {
            loop = "forward ";
        } else if (this.loopType == 2) {
            loop = "ping pong ";
        }
        sb.append(String.valueOf(loop) + " " + this.loopStart + " " + this.loopLength + "\n");
        return sb.toString();
    }

    public void setData(short[] data) {
        this.data = data;
    }

    public short[] getData() {
        return this.data;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public double getVolume() {
        return this.volume;
    }

    public double getPanning() {
        return this.panning;
    }

    public int getLength() {
        return this.length;
    }

    public int getLoopType() {
        return this.loopType;
    }

    public int getLoopStart() {
        return this.loopStart;
    }

    public int getLoopLength() {
        return this.loopLength;
    }

    public double getRelativeNote() {
        return this.relativeNote;
    }

    public double getFineTune() {
        return this.fineTune;
    }

    public void setUnits(ModuleUnits units) {
        this.units = units;
    }

    public ModuleUnits getUnits() {
        return this.units;
    }
}

